ORCA/M Asm65816 2.1.0

0001 9607                       title 'QD Conics            GS ROM 1.1'
0002 9607              ****************************************************************
0003 9607              *                                                              *
0004 9607              *                      Conics                                  *
0005 9607              *                                                              *
0006 9607              ****************************************************************
0007 9607
0008 9607
0009 9607              ****************************************************************
0010 9607              *                                                              *
0011 9607              *              Copyright (C) 1985-1987                         *
0012 9607              *              All Rights Reserved                             *
0013 9607              *              Apple Computer, Inc.                            *
0014 9607              *                                                              *
0015 9607              ****************************************************************
0016 9607
0017 9607                       include 'all.macros' 
0018 9607                       include ':QDEquates:qd.data.asm' 
0019 9607                       INCLUDE ':QDEquates:core.globals1' 
0020 9607                       INCLUDE ':QDEquates:core.globals2' 
0021 9607                       INCLUDE ':QDEquates:region.equs' 
0022 9607                       INCLUDE ':QDEquates:rect.equs' 
0023 9607                       INCLUDE ':QDEquates:slab.equs' 
0024 9607                       INCLUDE ':QDEquates:conics.equs' 
0025 9607
0026 9607
0027 9607              ;-----------------------------------------------
0028 9607              ;
0029 9607              ;   Imported addresses
0030 9607              ;
0031 9607              ;-----------------------------------------------
0032 9607
0033 9607                       IMPORT BusyErr 
0034 9607                       IMPORT CommonSlabSetup 
0035 9607                       IMPORT DerefHandle 
0036 9607                       IMPORT NextPatSlice 
0037 9607                       IMPORT QDStart 
0038 9607                       IMPORT ReSizeHandle 
0039 9607                       IMPORT RgnSave 
0040 9607                       IMPORT SetFirstDestRef 
0041 9607                       IMPORT SetNextDestRef 
0042 9607                       IMPORT TestGPs 
0043 9607                       IMPORT UnlockHandle 
0044 9607
0045 9607              ;-----------------------------------------------
0046 9607              ;
0047 9607              ;   Forward addresses and entries
0048 9607              ;
0049 9607              ;-----------------------------------------------
0050 9607
0051 9607                       ENTRY CallArc 
0052 9607                       ENTRY CallOval 
0053 9607                       ENTRY CallRRect 
0054 9607                       ENTRY ConicGetRect 
0055 9607                       ENTRY FrConic 
0056 9607                       ENTRY GetAngles 
0057 9607                       ENTRY GetWandH 
0058 9607                       ENTRY OvalPenSize 
0059 9607                       ENTRY iStdConic 
0060 9607
0061 9607
0062 9607              ;                copy conics/conics
0063 9607              *                      Table of Contents
0064 9607              *
0065 9607              * 1.  Ovals
0066 9607              *
0067 9607              *       FrameOval      Frames an oval
0068 9607              *       PaintOval      Paints an oval in the current pattern
0069 9607              *       EraseOval      Erases an oval
0070 9607              *       InvertOval     Inverts an oval
0071 9607              *       FillOval       Fills an oval with a pattern
0072 9607              *       CallOval       The oval bottleneck procedure
0073 9607              *       iStdConic      The standard conic routine, passed #?Noun in A
0074 9607              *
0075 9607              * 2.  Round Rects
0076 9607              *
0077 9607              *       FrameRRect     Frames a round rect
0078 9607              *       PaintRRect     Paints a round rect in the current pattern
0079 9607              *       EraseRRect     Erases a round rect
0080 9607              *       InvertRRect    Inverts a round rect
0081 9607              *       FillRRect      Fills a round rect with a pattern
0082 9607              *       CallRRect      The round rect bottleneck procedure
0083 9607              *
0084 9607              * 3. Arcs
0085 9607              *
0086 9607              *       FrameArc       Frames an arc
0087 9607              *       PaintArc       Paints an arc in the current pattern
0088 9607              *       EraseArc       Erases an arc
0089 9607              *       InvertArc      Inverts an arc
0090 9607              *       FillArc        Fills an arc with a pattern
0091 9607              *       CallArc        The arc bottleneck procedure
0092 9607              *
0093 9607              * 4. Environment and utility calls
0094 9607              *
0095 9607              *       ConicGetRect   Pulls rect into Y1... and OuterOval+OvalTop...
0096 9607              *       GetWandH       Pulls OvalWidth and OvalHeight off stack
0097 9607              *       GetAngles      Pulls StartAngle and ArcAngle off stack
0098 9607              *       AngleFromSlope Just like it sounds
0099 9607              *       SlopeFromAngle Just like this sounds, too
0100 9607              *       InitOval       Support routine for oval drawing
0101 9607              *       BumpOval       Bumps oval state record to next scan line
0102 9607              *       SetArcRot      Sets the grafport parameter for arc/oval rotation
0103 9607              *       GetArcRot      Returns the grafport parameter for oval rotation
0104 9607
0105 9607              ****************************************************************
0106 9607              *
0107 9607              * FrameOval(r:Rect)
0108 9607              *
0109 9607              ****************************************************************
0110 9607                       EXPORT FrameOval
0111 9607              FrameOval PROC 
0112 9607
0113 9607              *              using PicInfo
0114 9607
0115 9607 20 AA 0F              jsr   QDStart
0116 960A
0117 960A 20 8A 98              jsr   ConicGetRect
0118 960D
0119 960D 38                    sec   
0120 960E A5 AA                 lda   Y2
0121 9610 E5 A6                 sbc   Y1
0122 9612 85 B0                 sta   Rect2+2
0123 9614 38                    sec   
0124 9615 A5 AC                 lda   X2
0125 9617 E5 A8                 sbc   X1
0126 9619 85 AE                 sta   Rect2
0127 961B
0128 961B A2 00 00              ldx   #FrameVerb
0129 961E 22 85 96 FE           jsl   CallOval
0130 9622 AA                    tax   
0131 9623 A0 04 00              ldy   #4
0132 9626 4C AA FC              jmp   BusyErr
0133 9629
0134 9629
0135 9629
0136 9629                       ENDP 
0137 9629
0138 9629              ****************************************************************
0139 9629              *
0140 9629              * PaintOval(r:Rect)
0141 9629              *
0142 9629              ****************************************************************
0143 9629                       EXPORT PaintOval
0144 9629              PaintOval PROC 
0145 9629
0146 9629              *              using PicInfo
0147 9629
0148 9629 20 AA 0F              jsr   QDStart
0149 962C
0150 962C 20 8A 98              jsr   ConicGetRect
0151 962F A2 01 00              ldx   #PaintVerb
0152 9632 22 85 96 FE           jsl   CallOval
0153 9636 AA                    tax   
0154 9637 A0 04 00              ldy   #4
0155 963A 4C AA FC              jmp   BusyErr
0156 963D
0157 963D
0158 963D                       ENDP 
0159 963D
0160 963D              ****************************************************************
0161 963D              *
0162 963D              * EraseOval(r:Rect)
0163 963D              *
0164 963D              ****************************************************************
0165 963D                       EXPORT EraseOval
0166 963D              EraseOval PROC 
0167 963D
0168 963D              *              using PicInfo
0169 963D
0170 963D 20 AA 0F              jsr   QDStart
0171 9640
0172 9640 20 8A 98              jsr   ConicGetRect
0173 9643 A2 02 00              ldx   #EraseVerb
0174 9646 22 85 96 FE           jsl   CallOval
0175 964A AA                    tax   
0176 964B A0 04 00              ldy   #4
0177 964E 4C AA FC              jmp   BusyErr
0178 9651
0179 9651
0180 9651                       ENDP 
0181 9651
0182 9651              ****************************************************************
0183 9651              *
0184 9651              * InvertOval(r:Rect)
0185 9651              *
0186 9651              ****************************************************************
0187 9651                       EXPORT InvertOval
0188 9651              InvertOval PROC 
0189 9651
0190 9651              *              using PicInfo
0191 9651
0192 9651 20 AA 0F              jsr   QDStart
0193 9654
0194 9654 20 8A 98              jsr   ConicGetRect
0195 9657 A2 03 00              ldx   #InvertVerb
0196 965A 22 85 96 FE           jsl   CallOval
0197 965E AA                    tax   
0198 965F A0 04 00              ldy   #4
0199 9662 4C AA FC              jmp   BusyErr
0200 9665
0201 9665
0202 9665                       ENDP 
0203 9665
0204 9665              ****************************************************************
0205 9665              *
0206 9665              * FillOval(r:Rect; p:Pattern)
0207 9665              *
0208 9665              ****************************************************************
0209 9665                       EXPORT FillOval
0210 9665              FillOval PROC 
0211 9665
0212 9665              *              using PicInfo
0213 9665              *              using E0Vectors
0214 9665
0215 9665              OrigDirect equ   1
0216 9665              RTL1     equ   OrigDirect+2
0217 9665              RTL2     equ   RTL1+3
0218 9665              PPtr     equ   RTL2+3
0219 9665              RPtr     equ   PPtr+4
0220 9665
0221 9665 20 AA 0F              jsr   QDStart
0222 9668
0223 9668 22 40 1E E0           jsl   UserPat2ZP
0224 966C A3 0D                 lda   RPtr,s
0225 966E 83 09                 sta   PPtr,s
0226 9670 A3 0F                 lda   RPtr+2,s
0227 9672 83 0B                 sta   PPtr+2,s
0228 9674 20 8A 98              jsr   ConicGetRect
0229 9677
0230 9677 A2 04 00              ldx   #FillVerb
0231 967A 22 85 96 FE           jsl   CallOval
0232 967E AA                    tax   
0233 967F A0 08 00              ldy   #8
0234 9682 4C AA FC              jmp   BusyErr
0235 9685
0236 9685                       ENDP 
0237 9685
0238 9685              ****************************************************************
0239 9685              *
0240 9685              * CallOval
0241 9685              *
0242 9685              * This routine is jumped (or branched) to by the entry points
0243 9685              * after the graf verb is loaded into the X register.
0244 9685              * Zero page is already switched in by the time it gets here.
0245 9685              *
0246 9685              * Change History
0247 9685              *
0248 9685              * 23 Oct 88         Steven Glass
0249 9685              *
0250 9685              * The extra variables were being set after looking at the
0251 9685              * bottleneck pointer so that if there were custom bottleneck
0252 9685              * procs, these vars would not be setup correctly.
0253 9685              *
0254 9685              ****************************************************************
0255 9685              CallOval PROC 
0256 9685
0257 9685
0258 9685 86 38                 stx   DrawVerb                 ; save the verb
0259 9687
0260 9687              ;-----------------------------------------------------------
0261 9687              ;
0262 9687              ; Set up the other variables and then get call correct routine.
0263 9687              ;
0264 9687
0265 9687
0266 9687 A9 68 01              lda   #360                     ; a full oval
0267 968A 85 D2                 sta   ArcAngle
0268 968C 64 D4                 stz   StartAngle
0269 968E
0270 968E A2 00 02              ldx   #OuterOval
0271 9691 38                    sec   
0272 9692 A5 AA                 lda   Y2
0273 9694 E5 A6                 sbc   Y1
0274 9696 95 08                 sta   OvalHeight,x
0275 9698 38                    sec   
0276 9699 A5 AC                 lda   X2
0277 969B E5 A8                 sbc   X1
0278 969D 95 0A                 sta   OvalWidth,x
0279 969F
0280 969F              ;-----------------------------------------------------------
0281 969F              ;
0282 969F              ; Now, see how do we get there.
0283 969F
0284 969F 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0285 96A2 B0 04                 bcs   UseLocal
0286 96A4
0287 96A4 5C 14 1E E0           jml   StdOval
0288 96A8
0289 96A8 8B           UseLocal phb                            ; put extra byte on stack
0290 96A9 A0 10 00              ldy   #o_stdoval               ; get adr of new Oval routine
0291 96AC B7 2A                 lda   [temp],y                 ; put on stack
0292 96AE 48                    pha   
0293 96AF C8                    iny                            ; get bytes 2 and 3
0294 96B0 B7 2A                 lda   [temp],y
0295 96B2 83 02                 sta   2,s                      ; store middle byte twice
0296 96B4 6B                    rtl                            ; call it
0297 96B5
0298 96B5                       ENDP 
0299 96B5
0300 96B5              ****************************************************************
0301 96B5              *
0302 96B5              * iStdConic
0303 96B5              *
0304 96B5              * Common conic routine that is central point for all oval drawing.
0305 96B5              *
0306 96B5              * When control gets here, all inputs are on zero page.
0307 96B5              *       TheRect is kept in Y1 thru X2
0308 96B5              *       ThePat (if any) is in TheFillPat
0309 96B5              *       WhatToDo is in DrawVerb
0310 96B5              *
0311 96B5              ****************************************************************
0312 96B5                       EXPORT StdStuff
0313 96B5              StdStuff PROC 
0314 96B5
0315 96B5              *              using CoreDATA
0316 96B5              *              using PicInfo
0317 96B5              *              using QDProcs
0318 96B5              *              using E0Vectors
0319 96B5
0320 96B5                       EXPORT iStdArc
0321 96B5              iStdArc                                 ; 
0322 96B5
0323 96B5 A9 60 00              lda   #ArcNoun
0324 96B8 80 08                 bra   iStdConic
0325 96BA
0326 96BA                       EXPORT iStdOval
0327 96BA              iStdOval                                ; 
0328 96BA
0329 96BA A9 50 00              lda   #OvalNoun
0330 96BD 80 03                 bra   iStdConic
0331 96BF
0332 96BF                       EXPORT iStdRRect
0333 96BF              iStdRRect                               ; 
0334 96BF
0335 96BF A9 40 00              lda   #RRectNoun
0336 96C2
0337 96C2                       EXPORT iStdConic
0338 96C2              iStdConic                               ; 
0339 96C2
0340 96C2 85 3A                 sta   DrawNoun
0341 96C4 22 F8 1E E0           jsl   PutPictStuff             ; inputs on zp and in a-reg
0342 96C8 90 01                 bcc   NoPicErr
0343 96CA
0344 96CA 6B                    rtl                            ; return the error
0345 96CB
0346 96CB              NoPicErr                                ; 
0347 96CB
0348 96CB 64 EE                 stz   HollowFlag               ; ToFrConic overrides this below
0349 96CD
0350 96CD A5 38                 lda   DrawVerb                 ; put verb in a
0351 96CF D0 18                 bne   NotFrame
0352 96D1 A5 3A                 lda   DrawNoun
0353 96D3 C9 60 00              cmp   #ArcNoun
0354 96D6 F0 0C                 beq   ToFrConic
0355 96D8 20 45 6B              jsr   RgnSave                  ; does this contribute to region def
0356 96DB 90 07                 bcc   ToFrConic                ; no, so frame it
0357 96DD 22 9C 1F E0           jsl   PutOval                  ; yes, so call putrect
0358 96E1 90 01                 bcc   ToFrConic                ; no error so frame it.
0359 96E3
0360 96E3 6B                    rtl                            ; return the error
0361 96E4
0362 96E4 E6 EE        ToFrConic inc   HollowFlag              ; we want a hollow oval
0363 96E6 82 1E 05              brl   FrConic
0364 96E9
0365 96E9              NotFrame                                ; 
0366 96E9
0367 96E9 4C A4 2E              jmp   CommonSlabSetup
0368 96EC
0369 96EC                       ENDP 
0370 96EC
0371 96EC              ****************************************************************
0372 96EC              *
0373 96EC              * FrameRRect(r:Rect)
0374 96EC              *
0375 96EC              ****************************************************************
0376 96EC                       EXPORT FrameRRect
0377 96EC              FrameRRect PROC 
0378 96EC
0379 96EC              OrigDirect equ   1
0380 96EC              RTL1     equ   OrigDirect+2
0381 96EC              RTL2     equ   RTL1+3
0382 96EC              oheight  equ   RTL2+3
0383 96EC              owidth   equ   oHeight+2
0384 96EC              RPtr     equ   oWidth+2
0385 96EC
0386 96EC              *              using PicInfo
0387 96EC
0388 96EC 20 AA 0F              jsr   QDStart
0389 96EF
0390 96EF 20 A8 98              jsr   GetWandH
0391 96F2 A2 00 02              ldx   #OuterOval
0392 96F5 B5 08                 lda   OvalHeight,x
0393 96F7 85 B0                 sta   Rect2+2
0394 96F9 B5 0A                 lda   OvalWidth,x
0395 96FB 85 AE                 sta   Rect2
0396 96FD
0397 96FD A3 0D                 lda   RPtr,s
0398 96FF 83 09                 sta   oHeight,s
0399 9701 A3 0F                 lda   RPtr+2,s
0400 9703 83 0B                 sta   oHeight+2,s
0401 9705
0402 9705
0403 9705 20 8A 98              jsr   ConicGetRect
0404 9708 A2 00 00              ldx   #FrameVerb
0405 970B 22 9E 97 FE           jsl   CallRRect
0406 970F AA                    tax   
0407 9710 A0 08 00              ldy   #8
0408 9713 4C AA FC              jmp   BusyErr
0409 9716
0410 9716                       ENDP 
0411 9716
0412 9716              ****************************************************************
0413 9716              *
0414 9716              * PaintRRect(r:Rect)
0415 9716              *
0416 9716              ****************************************************************
0417 9716                       EXPORT PaintRRect
0418 9716              PaintRRect PROC 
0419 9716
0420 9716              OrigDirect equ   1
0421 9716              RTL1     equ   OrigDirect+2
0422 9716              RTL2     equ   RTL1+3
0423 9716              oheight  equ   RTL2+3
0424 9716              owidth   equ   oHeight+2
0425 9716              RPtr     equ   oWidth+2
0426 9716
0427 9716              *              using PicInfo
0428 9716
0429 9716 20 AA 0F              jsr   QDStart
0430 9719
0431 9719 20 A8 98              jsr   GetWandH
0432 971C
0433 971C A3 0D                 lda   RPtr,s
0434 971E 83 09                 sta   oHeight,s
0435 9720 A3 0F                 lda   RPtr+2,s
0436 9722 83 0B                 sta   oHeight+2,s
0437 9724
0438 9724 20 8A 98              jsr   ConicGetRect
0439 9727 A2 01 00              ldx   #PaintVerb
0440 972A 22 9E 97 FE           jsl   CallRRect
0441 972E AA                    tax   
0442 972F A0 08 00              ldy   #8
0443 9732 4C AA FC              jmp   BusyErr
0444 9735
0445 9735
0446 9735                       ENDP 
0447 9735
0448 9735              ****************************************************************
0449 9735              *
0450 9735              * EraseRRect(r:Rect)
0451 9735              *
0452 9735              ****************************************************************
0453 9735                       EXPORT EraseRRect
0454 9735              EraseRRect PROC 
0455 9735
0456 9735              OrigDirect equ   1
0457 9735              RTL1     equ   OrigDirect+2
0458 9735              RTL2     equ   RTL1+3
0459 9735              oheight  equ   RTL2+3
0460 9735              owidth   equ   oHeight+2
0461 9735              RPtr     equ   oWidth+2
0462 9735
0463 9735              *              using PicInfo
0464 9735
0465 9735 20 AA 0F              jsr   QDStart
0466 9738
0467 9738 20 A8 98              jsr   GetWandH
0468 973B
0469 973B A3 0D                 lda   RPtr,s
0470 973D 83 09                 sta   oHeight,s
0471 973F A3 0F                 lda   RPtr+2,s
0472 9741 83 0B                 sta   oHeight+2,s
0473 9743
0474 9743 20 8A 98              jsr   ConicGetRect
0475 9746 A2 02 00              ldx   #EraseVerb
0476 9749 22 9E 97 FE           jsl   CallRRect
0477 974D AA                    tax   
0478 974E A0 08 00              ldy   #8
0479 9751 4C AA FC              jmp   BusyErr
0480 9754
0481 9754
0482 9754                       ENDP 
0483 9754
0484 9754              ****************************************************************
0485 9754              *
0486 9754              * InvertRRect(r:Rect)
0487 9754              *
0488 9754              ****************************************************************
0489 9754                       EXPORT InvertRRect
0490 9754              InvertRRect PROC 
0491 9754
0492 9754              OrigDirect equ   1
0493 9754              RTL1     equ   OrigDirect+2
0494 9754              RTL2     equ   RTL1+3
0495 9754              oheight  equ   RTL2+3
0496 9754              owidth   equ   oHeight+2
0497 9754              RPtr     equ   oWidth+2
0498 9754
0499 9754              *              using PicInfo
0500 9754
0501 9754 20 AA 0F              jsr   QDStart
0502 9757
0503 9757 20 A8 98              jsr   GetWandH
0504 975A
0505 975A A3 0D                 lda   RPtr,s
0506 975C 83 09                 sta   oHeight,s
0507 975E A3 0F                 lda   RPtr+2,s
0508 9760 83 0B                 sta   oHeight+2,s
0509 9762
0510 9762 20 8A 98              jsr   ConicGetRect
0511 9765 A2 03 00              ldx   #InvertVerb
0512 9768 22 9E 97 FE           jsl   CallRRect
0513 976C AA                    tax   
0514 976D A0 08 00              ldy   #8
0515 9770 4C AA FC              jmp   BusyErr
0516 9773
0517 9773
0518 9773                       ENDP 
0519 9773
0520 9773              ****************************************************************
0521 9773              *
0522 9773              * FillRRect(r:Rect; p:Pattern)
0523 9773              *
0524 9773              ****************************************************************
0525 9773                       EXPORT FillRRect
0526 9773              FillRRect PROC 
0527 9773
0528 9773              OrigDirect equ   1
0529 9773              RTL1     equ   OrigDirect+2
0530 9773              RTL2     equ   RTL1+3
0531 9773              PPtr     equ   RTL2+3
0532 9773              oheight  equ   PPtr+4
0533 9773              owidth   equ   oHeight+2
0534 9773              RPtr     equ   oWidth+2
0535 9773
0536 9773              *              using PicInfo
0537 9773              *              using E0Vectors
0538 9773
0539 9773 20 AA 0F              jsr   QDStart
0540 9776
0541 9776
0542 9776 22 40 1E E0           jsl   UserPat2ZP
0543 977A
0544 977A A2 00 02              ldx   #OuterOval
0545 977D
0546 977D A3 0D                 lda   Oheight,s
0547 977F 95 08                 sta   OvalHeight,x
0548 9781 A3 0F                 lda   Owidth,s
0549 9783 95 0A                 sta   OvalWidth,x
0550 9785
0551 9785 A3 11                 lda   RPtr,s
0552 9787 83 09                 sta   PPtr,s
0553 9789 A3 13                 lda   RPtr+2,s
0554 978B 83 0B                 sta   PPtr+2,s
0555 978D 20 8A 98              jsr   ConicGetRect
0556 9790
0557 9790 A2 04 00              ldx   #FillVerb
0558 9793 22 9E 97 FE           jsl   CallRRect
0559 9797 AA                    tax   
0560 9798 A0 0C 00              ldy   #12
0561 979B 4C AA FC              jmp   BusyErr
0562 979E
0563 979E
0564 979E                       ENDP 
0565 979E
0566 979E              ****************************************************************
0567 979E              *
0568 979E              * CallRRect
0569 979E              *
0570 979E              * This routine is jumped (or branched) to by the
0571 979E              * entry points after the graf verb is loaded into the
0572 979E              * x register.
0573 979E              *
0574 979E              * Zero page is already switched in by the time it gets here.
0575 979E              *
0576 979E              * Change History
0577 979E              *
0578 979E              * 23 Oct 88         Steven Glass
0579 979E              *
0580 979E              * The extra variables were being set after looking at the
0581 979E              * bottleneck pointer so that if there were custom bottleneck
0582 979E              * procs, these vars would not be setup correctly.
0583 979E              *
0584 979E              ****************************************************************
0585 979E              CallRRect PROC 
0586 979E
0587 979E 86 38                 stx   DrawVerb
0588 97A0
0589 97A0              ;-----------------------------------------------------------
0590 97A0              ;
0591 97A0              ; Now setup arcangle and start angle
0592 97A0              ;
0593 97A0 A9 68 01              lda   #360                     ; a full oval
0594 97A3 85 D2                 sta   ArcAngle
0595 97A5 64 D4                 stz   StartAngle
0596 97A7
0597 97A7
0598 97A7              ;-----------------------------------------------------------
0599 97A7              ;
0600 97A7              ; Look at grafProcs ptr.
0601 97A7
0602 97A7 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0603 97AA B0 04                 bcs   UseLocal
0604 97AC
0605 97AC 5C 10 1E E0           jml   StdRRect
0606 97B0
0607 97B0
0608 97B0 8B           UseLocal phb                            ; put extra byte on stack
0609 97B1 A0 0C 00              ldy   #o_stdRRect              ; get adr of new RRect routine
0610 97B4 B7 2A                 lda   [temp],y                 ; put on stack
0611 97B6 48                    pha   
0612 97B7 C8                    iny                            ; get bytes 2 and 3
0613 97B8 B7 2A                 lda   [temp],y
0614 97BA 83 02                 sta   2,s                      ; store middle byte twice
0615 97BC 6B                    rtl                            ; call it
0616 97BD
0617 97BD                       ENDP 
0618 97BD
0619 97BD              ****************************************************************
0620 97BD              *
0621 97BD              * FrameArc(r:Rect; StartAngle,ArcAngle:integer)
0622 97BD              *
0623 97BD              ****************************************************************
0624 97BD                       EXPORT FrameArc
0625 97BD              FrameArc PROC 
0626 97BD              *              using PicInfo
0627 97BD
0628 97BD              OrigDirect equ   1
0629 97BD              RTL1     equ   OrigDirect+2
0630 97BD              RTL2     equ   RTL1+3
0631 97BD              AAngle   equ   RTL2+3
0632 97BD              SAngle   equ   AAngle+2
0633 97BD              RPtr     equ   SAngle+2
0634 97BD
0635 97BD 20 AA 0F              jsr   QDStart
0636 97C0
0637 97C0 20 B4 98              jsr   GetAngles
0638 97C3
0639 97C3 A3 0D                 lda   RPtr,s
0640 97C5 83 09                 sta   AAngle,s
0641 97C7 A3 0F                 lda   RPtr+2,s
0642 97C9 83 0B                 sta   AAngle+2,s
0643 97CB
0644 97CB 20 8A 98              jsr   ConicGetRect
0645 97CE A2 00 00              ldx   #FrameVerb
0646 97D1 22 61 98 FE           jsl   CallArc
0647 97D5 AA                    tax   
0648 97D6 A0 08 00              ldy   #8
0649 97D9 4C AA FC              jmp   BusyErr
0650 97DC
0651 97DC
0652 97DC                       ENDP 
0653 97DC
0654 97DC              ****************************************************************
0655 97DC              *
0656 97DC              * PaintArc(r:Rect; StartAngle,ArcAngle:integer)
0657 97DC              *
0658 97DC              ****************************************************************
0659 97DC                       EXPORT PaintArc
0660 97DC              PaintArc PROC 
0661 97DC              *             using	PicInfo
0662 97DC
0663 97DC              OrigDirect equ   1
0664 97DC              RTL1     equ   OrigDirect+2
0665 97DC              RTL2     equ   RTL1+3
0666 97DC              AAngle   equ   RTL2+3
0667 97DC              SAngle   equ   AAngle+2
0668 97DC              RPtr     equ   SAngle+2
0669 97DC
0670 97DC 20 AA 0F              jsr   QDStart
0671 97DF
0672 97DF 20 B4 98              jsr   GetAngles
0673 97E2
0674 97E2 A3 0D                 lda   RPtr,s
0675 97E4 83 09                 sta   AAngle,s
0676 97E6 A3 0F                 lda   RPtr+2,s
0677 97E8 83 0B                 sta   AAngle+2,s
0678 97EA
0679 97EA 20 8A 98              jsr   ConicGetRect
0680 97ED A2 01 00              ldx   #PaintVerb
0681 97F0 22 61 98 FE           jsl   CallArc
0682 97F4 AA                    tax   
0683 97F5 A0 08 00              ldy   #8
0684 97F8 4C AA FC              jmp   BusyErr
0685 97FB
0686 97FB
0687 97FB                       ENDP 
0688 97FB
0689 97FB              ****************************************************************
0690 97FB              *
0691 97FB              * EraseArc(r:Rect; StartAngle,ArcAngle:integer)
0692 97FB              *
0693 97FB              ****************************************************************
0694 97FB                       EXPORT EraseArc
0695 97FB              EraseArc PROC 
0696 97FB              *              using PicInfo
0697 97FB
0698 97FB              OrigDirect equ   1
0699 97FB              RTL1     equ   OrigDirect+2
0700 97FB              RTL2     equ   RTL1+3
0701 97FB              AAngle   equ   RTL2+3
0702 97FB              SAngle   equ   AAngle+2
0703 97FB              RPtr     equ   SAngle+2
0704 97FB
0705 97FB 20 AA 0F              jsr   QDStart
0706 97FE
0707 97FE 20 B4 98              jsr   GetAngles
0708 9801
0709 9801 A3 0D                 lda   RPtr,s
0710 9803 83 09                 sta   AAngle,s
0711 9805 A3 0F                 lda   RPtr+2,s
0712 9807 83 0B                 sta   AAngle+2,s
0713 9809
0714 9809 20 8A 98              jsr   ConicGetRect
0715 980C A2 02 00              ldx   #EraseVerb
0716 980F 22 61 98 FE           jsl   CallArc
0717 9813 AA                    tax   
0718 9814 A0 08 00              ldy   #8
0719 9817 4C AA FC              jmp   BusyErr
0720 981A
0721 981A
0722 981A                       ENDP 
0723 981A
0724 981A              ****************************************************************
0725 981A              *
0726 981A              * InvertArc(r:Rect; StartAngle,ArcAngle:integer)
0727 981A              *
0728 981A              ****************************************************************
0729 981A                       EXPORT InvertArc
0730 981A              InvertArc PROC 
0731 981A              *              using PicInfo
0732 981A
0733 981A              OrigDirect equ   1
0734 981A              RTL1     equ   OrigDirect+2
0735 981A              RTL2     equ   RTL1+3
0736 981A              AAngle   equ   RTL2+3
0737 981A              SAngle   equ   AAngle+2
0738 981A              RPtr     equ   SAngle+2
0739 981A
0740 981A 20 AA 0F              jsr   QDStart
0741 981D
0742 981D 20 B4 98              jsr   GetAngles
0743 9820
0744 9820 A3 0D                 lda   RPtr,s
0745 9822 83 09                 sta   AAngle,s
0746 9824 A3 0F                 lda   RPtr+2,s
0747 9826 83 0B                 sta   AAngle+2,s
0748 9828
0749 9828 20 8A 98              jsr   ConicGetRect
0750 982B A2 03 00              ldx   #InvertVerb
0751 982E 22 61 98 FE           jsl   CallArc
0752 9832 AA                    tax   
0753 9833 A0 08 00              ldy   #8
0754 9836 4C AA FC              jmp   BusyErr
0755 9839
0756 9839
0757 9839                       ENDP 
0758 9839
0759 9839              ****************************************************************
0760 9839              *
0761 9839              * FillArc(r:Rect; StartAngle,ArcAngle:integer; p:PatPtr)
0762 9839              *
0763 9839              ****************************************************************
0764 9839                       EXPORT FillArc
0765 9839              FillArc  PROC 
0766 9839
0767 9839              *              using PicInfo
0768 9839              *              using E0Vectors
0769 9839
0770 9839              OrigDirect equ   1
0771 9839              RTL1     equ   OrigDirect+2
0772 9839              RTL2     equ   RTL1+3
0773 9839              PPtr     equ   RTL2+3
0774 9839              AAngle   equ   PPtr+4
0775 9839              SAngle   equ   AAngle+2
0776 9839              RPtr     equ   SAngle+2
0777 9839
0778 9839 20 AA 0F              jsr   QDStart
0779 983C
0780 983C 22 40 1E E0           jsl   UserPat2ZP
0781 9840
0782 9840 A3 0F                 lda   SAngle,s
0783 9842 85 D4                 sta   StartAngle
0784 9844 A3 0D                 lda   AAngle,s
0785 9846 85 D2                 sta   ArcAngle
0786 9848
0787 9848 A3 11                 lda   RPtr,s
0788 984A 83 09                 sta   PPtr,s
0789 984C A3 13                 lda   RPtr+2,s
0790 984E 83 0B                 sta   PPtr+2,s
0791 9850 20 8A 98              jsr   ConicGetRect
0792 9853
0793 9853 A2 04 00              ldx   #FillVerb
0794 9856 22 61 98 FE           jsl   CallArc
0795 985A AA                    tax   
0796 985B A0 0C 00              ldy   #12
0797 985E 4C AA FC              jmp   BusyErr
0798 9861
0799 9861
0800 9861                       ENDP 
0801 9861
0802 9861              ****************************************************************
0803 9861              *
0804 9861              * CallArc
0805 9861              *
0806 9861              * This routine is jumped (or branched) to by the
0807 9861              * entry points after the graf verb is loaded into the
0808 9861              * x register.
0809 9861              *
0810 9861              * Zero page is already switched in by the time it gets here.
0811 9861              *
0812 9861              * Change History
0813 9861              *
0814 9861              * 23 Oct 88         Steven Glass
0815 9861              *
0816 9861              * The extra variables were being set after looking at the
0817 9861              * bottleneck pointer so that if there were custom bottleneck
0818 9861              * procs, these vars would not be setup correctly.
0819 9861              *
0820 9861              ****************************************************************
0821 9861              CallArc  PROC 
0822 9861
0823 9861
0824 9861 86 38                 stx   DrawVerb
0825 9863
0826 9863              ;-----------------------------------------------------------
0827 9863              ;
0828 9863              ; Setup these other parameters before checking the grafprocs
0829 9863              ;
0830 9863 A2 00 02              ldx   #OuterOval
0831 9866 38                    sec   
0832 9867 A5 AA                 lda   Y2
0833 9869 E5 A6                 sbc   Y1
0834 986B 95 08                 sta   OvalHeight,x
0835 986D 38                    sec   
0836 986E A5 AC                 lda   X2
0837 9870 E5 A8                 sbc   X1
0838 9872 95 0A                 sta   OvalWidth,x
0839 9874
0840 9874              ;-----------------------------------------------------------
0841 9874              ;
0842 9874              ; Check the grafprocs.
0843 9874              ;
0844 9874 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0845 9877 B0 04                 bcs   UseLocal
0846 9879
0847 9879 5C 18 1E E0           jml   StdArc
0848 987D
0849 987D
0850 987D
0851 987D 8B           UseLocal phb                            ; put extra byte on stack
0852 987E A0 14 00              ldy   #o_stdArc                ; get adr of new Arc routine
0853 9881 B7 2A                 lda   [temp],y                 ; put on stack
0854 9883 48                    pha   
0855 9884 C8                    iny                            ; get bytes 2 and 3
0856 9885 B7 2A                 lda   [temp],y
0857 9887 83 02                 sta   2,s                      ; store middle byte twice
0858 9889 6B                    rtl                            ; call it
0859 988A
0860 988A                       ENDP 
0861 988A
0862 988A              ****************************************************************
0863 988A              *
0864 988A              * ConicGetRect
0865 988A              *
0866 988A              * Gets the rectangle pointer off the stack, and copies the rect
0867 988A              * to Y1..X2 and to OuterOval+OvalTop..OvalRight
0868 988A              *
0869 988A              ****************************************************************
0870 988A                       EXPORT ConicGetRect
0871 988A              ConicGetRect PROC 
0872 988A
0873 988A              RTSAdr   equ   1
0874 988A              OrigDirect equ   RTSAdr+2
0875 988A              RTL1     equ   OrigDirect+2
0876 988A              RTL2     equ   RTL1+3
0877 988A              RPtr     equ   RTL2+3
0878 988A
0879 988A A3 0B                 lda   RPtr,s
0880 988C 85 2A                 sta   Temp
0881 988E A3 0D                 lda   RPtr+2,s
0882 9890 85 2C                 sta   Temp+2
0883 9892
0884 9892 A2 06 02              ldx   #OuterOval+6
0885 9895 A0 06 00              ldy   #6
0886 9898 DA           PLoop    phx   
0887 9899 BB                    tyx   
0888 989A B7 2A                 lda   [Temp],y
0889 989C 95 A6                 sta   Y1,x
0890 989E FA                    plx   
0891 989F 95 00                 sta   OvalTop,x
0892 98A1 CA                    dex   
0893 98A2 CA                    dex   
0894 98A3 88                    dey   
0895 98A4 88                    dey   
0896 98A5 10 F1                 bpl   PLoop
0897 98A7
0898 98A7 60                    rts   
0899 98A8
0900 98A8                       ENDP 
0901 98A8
0902 98A8              ****************************************************************
0903 98A8              *
0904 98A8              * GetWandH
0905 98A8              *
0906 98A8              * Gets the width and height off the stack and puts them on
0907 98A8              * zero page.
0908 98A8              *
0909 98A8              ****************************************************************
0910 98A8                       EXPORT GetWandH
0911 98A8              GetWandH PROC 
0912 98A8
0913 98A8              RtsAdr   equ   1
0914 98A8              OrigDirect equ   RtsAdr+2
0915 98A8              RTL1     equ   OrigDirect+2
0916 98A8              RTL2     equ   RTL1+3
0917 98A8              Oheight  equ   RTL2+3
0918 98A8              Owidth   equ   oHeight+2
0919 98A8
0920 98A8 A2 00 02              ldx   #OuterOval
0921 98AB
0922 98AB A3 0B                 lda   Oheight,s
0923 98AD 95 08                 sta   OvalHeight,x
0924 98AF A3 0D                 lda   Owidth,s
0925 98B1 95 0A                 sta   OvalWidth,x
0926 98B3
0927 98B3 60                    rts   
0928 98B4
0929 98B4                       ENDP 
0930 98B4
0931 98B4              ****************************************************************
0932 98B4              *
0933 98B4              * GetAngles
0934 98B4              *
0935 98B4              * Gets the StartAngle and ArcAngle off the stack and puts them on
0936 98B4              * zero page.
0937 98B4              *
0938 98B4              ****************************************************************
0939 98B4                       EXPORT GetAngles
0940 98B4              GetAngles PROC 
0941 98B4
0942 98B4              RtsAdr   equ   1
0943 98B4              OrigDirect equ   RtsAdr+2
0944 98B4              RTL1     equ   OrigDirect+2
0945 98B4              RTL2     equ   RTL1+3
0946 98B4              AAngle   equ   RTL2+3
0947 98B4              SAngle   equ   AAngle+2
0948 98B4
0949 98B4 A3 0D                 lda   SAngle,s
0950 98B6 85 D4                 sta   StartAngle
0951 98B8 A3 0B                 lda   AAngle,s
0952 98BA 85 D2                 sta   ArcAngle
0953 98BC
0954 98BC 60                    rts   
0955 98BD
0956 98BD                       ENDP 
0957 98BD
0958 98BD              ****************************************************************
0959 98BD              *
0960 98BD              * Function iAngleFromSlope:integer
0961 98BD              *
0962 98BD              ****************************************************************
0963 98BD                       EXPORT iAngleFromSlope
0964 98BD              iAngleFromSlope PROC 
0965 98BD
0966 98BD              * Parameter is passed in Slope, which is equated with Temp2.  This
0967 98BD              * routine destroys Temp as well (Angle and SlopeSign).  When it
0968 98BD              * calls SlopeFromAngle it also destroys Slope2.  To begin
0969 98BD              * make the slope positive, but remember the sign.
0970 98BD
0971 98BD 64 2C                 stz   SlopeSign                ; zero slope sign boolean
0972 98BF 06 30                 asl   Slope+2                  ; move sign into carry
0973 98C1 26 2C                 rol   SlopeSign                ; and into SlopeSign
0974 98C3 F0 13                 beq   PositiveSlope
0975 98C5
0976 98C5              * Negate slope to make it positive
0977 98C5
0978 98C5 A5 2E                 lda   Slope
0979 98C7 49 FF FF              eor   #$FFFF
0980 98CA 1A                    inc   a
0981 98CB 85 2E                 sta   Slope
0982 98CD F0 02                 beq   NoDockHigh
0983 98CF C6 30                 dec   Slope+2                  ; becomes a carry after eor #$FFFF
0984 98D1 A5 30        NoDockHigh lda   Slope+2
0985 98D3 49 FF FF              eor   #$FFFF
0986 98D6 85 30                 sta   Slope+2
0987 98D8
0988 98D8 38           PositiveSlope sec                       ; bias the compare by 500
0989 98D9 A5 2E                 lda   Slope
0990 98DB E9 F4 01              sbc   #500
0991 98DE B0 02                 bcs   NoDock1
0992 98E0 C6 30                 dec   Slope+2
0993 98E2
0994 98E2 64 2A        NoDock1  stz   Angle
0995 98E4 80 02                 bra   ScanInside
0996 98E6
0997 98E6 E6 2A        Scan     inc   Angle                    ; A2Slope won't change it
0998 98E8 20 4C 99     ScanInside jsr   A2Slope                ; returns the slope for Angle
0999 98EB A5 E4                 lda   Slope2+2
1000 98ED C5 30                 cmp   Slope+2
1001 98EF 30 F5                 bmi   Scan
1002 98F1 D0 06                 bne   FoundIt
1003 98F3 A5 E2                 lda   Slope2
1004 98F5 C5 2E                 cmp   Slope
1005 98F7 30 ED                 bmi   Scan
1006 98F9
1007 98F9              * We equal or exceed Slope, so we've found it
1008 98F9
1009 98F9 A5 2C        FoundIt  lda   SlopeSign
1010 98FB F0 08                 beq   DontInvertIt
1011 98FD 38                    sec   
1012 98FE A9 B4 00              lda   #180
1013 9901 E5 2A                 sbc   Angle
1014 9903 85 2A                 sta   Angle
1015 9905 6B           DontInvertIt rtl   
1016 9906
1017 9906
1018 9906              * SlopeFromAngle uses the zero page value Angle (which falls on top of
1019 9906              * Temp) and returns its result in Slope2 (which makes life convenient
1020 9906              * for DrawArc, actually).  SlopeSign overlaps Temp+2.
1021 9906
1022 9906                       EXPORT iSlopeFromAngle
1023 9906              iSlopeFromAngle                         ; 
1024 9906
1025 9906 A5 2A                 lda   Angle
1026 9908 80 04                 bra   AngleCmp
1027 990A
1028 990A 38           TruncAngle sec   
1029 990B E9 B4 00              sbc   #180
1030 990E C9 B4 00     AngleCmp cmp   #180
1031 9911 10 F7                 bpl   TruncAngle
1032 9913 AA                    tax                            ; to set flags on A
1033 9914 10 06                 bpl   AngleOkay
1034 9916 18           PushAngle clc   
1035 9917 69 B4 00              adc   #180
1036 991A 30 FA                 bmi   PushAngle
1037 991C 85 2A        AngleOkay sta   Angle                   ; angle is in the range 0..179
1038 991E 64 2C                 stz   SlopeSign
1039 9920 C9 5B 00              cmp   #91
1040 9923 30 0C                 bmi   NotOverNinety
1041 9925 E6 2C                 inc   SlopeSign
1042 9927 38                    sec   
1043 9928 E9 B4 00              sbc   #180
1044 992B 49 FF FF              eor   #$FFFF
1045 992E 1A                    inc   a
1046 992F 85 2A                 sta   Angle
1047 9931 20 4C 99     NotOverNinety jsr   A2Slope
1048 9934 A5 2C                 lda   SlopeSign
1049 9936 D0 13                 bne   Done
1050 9938 A5 E2                 lda   Slope2
1051 993A 49 FF FF              eor   #$FFFF
1052 993D 1A                    inc   a
1053 993E 85 E2                 sta   Slope2
1054 9940 D0 02                 bne   NoDockSlope
1055 9942 C6 E4                 dec   Slope2+2
1056 9944 A5 E4        NoDockSlope lda   Slope2+2
1057 9946 49 FF FF              eor   #$FFFF
1058 9949 85 E4                 sta   Slope2+2
1059 994B 6B           Done     rtl   
1060 994C
1061 994C              * A2Slope is the local routine that does all the work.
1062 994C
1063 994C A9 5A 00     A2Slope  lda   #90
1064 994F C5 2A                 cmp   Angle
1065 9951 D0 0B                 bne   NonNinety
1066 9953 A9 FF 3F              lda   #MaxInt                  ; this may be wrong
1067 9956 85 E4                 sta   Slope2+2
1068 9958 A9 FF FF              lda   #$FFFF
1069 995B 85 E2                 sta   Slope2
1070 995D 60                    rts   
1071 995E
1072 995E 64 E4        NonNinety stz   Slope2+2
1073 9960 A5 2A                 lda   Angle                    ; if Angle < 45, Slope+2 = 0
1074 9962 C9 2D 00              cmp   #45
1075 9965 30 13                 bmi   Share
1076 9967 E6 E4                 inc   Slope2+2                 ; if Angle < 64, Slope+2 = 1
1077 9969 C9 40 00              cmp   #64
1078 996C 30 0C                 bmi   Share
1079 996E AA                    tax                            ; use it as an index
1080 996F BF 47 99 FE           lda   >HiSlopeTab-60,x         ; pick up the high word, low byte
1081 9973 29 FF 00              and   #$00FF                   ; only 90 deg has anything in high byte
1082 9976 85 E4                 sta   Slope2+2                 ; save the high word
1083 9978 A5 2A                 lda   Angle                    ; get the low word
1084 997A 0A           Share    asl   A
1085 997B AA                    tax   
1086 997C BF A1 99 FE           lda   >SlopeTable,x
1087 9980 85 E2                 sta   Slope2
1088 9982 60                    rts   
1089 9983
1090 9983              *              dc i1'$01,$01,$01,$01,$01'       ; 45-49
1091 9983              *              dc i1'$01,$01,$01,$01,$01'       ; 50-54
1092 9983              *              dc i1'$01,$01,$01,$01,$01'       ; 55-59
1093 9983 01 01 01 01  HiSlopeTab DC B:$01,$01,$01,$01,$02     ; 60-64
1094 9988 02 02 02 02           DC B:$02,$02,$02,$02,$02       ; 65-69
1095 998D 02 02 03 03           DC B:$02,$02,$03,$03,$03       ; 70-74
1096 9992 03 04 04 04           DC B:$03,$04,$04,$04,$05       ; 75-79
1097 9997 05 06 07 08           DC B:$05,$06,$07,$08,$09       ; 80-84
1098 999C 0B 0E 13 1C           DC B:$0B,$0E,$13,$1C,$39       ; 85-89
1099 99A1
1100 99A1 00 00        SlopeTable DC W:$0000                   ; 0
1101 99A3 78 04                 DC W:$0478
1102 99A5 F1 08                 DC W:$08F1
1103 99A7 6B 0D                 DC W:$0D6B
1104 99A9 E7 11                 DC W:$11E7
1105 99AB 66 16                 DC W:$1666                     ; 5
1106 99AD E8 1A                 DC W:$1AE8
1107 99AF 6F 1F                 DC W:$1F6F
1108 99B1 FA 23                 DC W:$23FA
1109 99B3 8C 28                 DC W:$288C
1110 99B5 24 2D                 DC W:$2D24                     ; 10
1111 99B7 C3 31                 DC W:$31C3
1112 99B9 6A 36                 DC W:$366A
1113 99BB 1A 3B                 DC W:$3B1A
1114 99BD D4 3F                 DC W:$3FD4
1115 99BF 98 44                 DC W:$4498                     ; 15
1116 99C1 68 49                 DC W:$4968
1117 99C3 44 4E                 DC W:$4E44
1118 99C5 2E 53                 DC W:$532E
1119 99C7 26 58                 DC W:$5826
1120 99C9 2D 5D                 DC W:$5D2D                     ; 20
1121 99CB 45 62                 DC W:$6245
1122 99CD 6E 67                 DC W:$676E
1123 99CF AA 6C                 DC W:$6CAA
1124 99D1 FB 71                 DC W:$71FB
1125 99D3 60 77                 DC W:$7760                     ; 25
1126 99D5 DC 7C                 DC W:$7CDC
1127 99D7 70 82                 DC W:$8270
1128 99D9 1E 88                 DC W:$881E
1129 99DB E7 8D                 DC W:$8DE7
1130 99DD CD 93                 DC W:$93CD                     ; 30
1131 99DF D2 99                 DC W:$99D2
1132 99E1 F7 9F                 DC W:$9FF7
1133 99E3 40 A6                 DC W:$A640
1134 99E5 AD AC                 DC W:$ACAD
1135 99E7 41 B3                 DC W:$B341                     ; 35
1136 99E9 FF B9                 DC W:$B9FF
1137 99EB E9 C0                 DC W:$C0E9
1138 99ED 02 C8                 DC W:$C802
1139 99EF 4E CF                 DC W:$CF4E
1140 99F1 CF D6                 DC W:$D6CF                     ; 40
1141 99F3 8A DE                 DC W:$DE8A
1142 99F5 81 E6                 DC W:$E681
1143 99F7 B9 EE                 DC W:$EEB9
1144 99F9 37 F7                 DC W:$F737
1145 99FB 00 00                 DC W:$0000                     ; 45
1146 99FD 19 09                 DC W:$0919
1147 99FF 87 12                 DC W:$1287
1148 9A01 51 1C                 DC W:$1C51
1149 9A03 7F 26                 DC W:$267F
1150 9A05 17 31                 DC W:$3117                     ; 50
1151 9A07 22 3C                 DC W:$3C22
1152 9A09 AA 47                 DC W:$47AA
1153 9A0B B9 53                 DC W:$53B9
1154 9A0D 5B 60                 DC W:$605B
1155 9A0F 98 6D                 DC W:$6D98                     ; 55
1156 9A11 89 7B                 DC W:$7B89
1157 9A13 35 8A                 DC W:$8A35
1158 9A15 AF 99                 DC W:$99AF
1159 9A17 0E AA                 DC W:$AA0E
1160 9A19 68 BB                 DC W:$BB68                     ; 60
1161 9A1B D6 CD                 DC W:$CDD6
1162 9A1D 77 E1                 DC W:$E177
1163 9A1F 6E F6                 DC W:$F66E
1164 9A21 E1 0C                 DC W:$0CE1
1165 9A23 FE 24                 DC W:$24FE                     ; 65
1166 9A25 FC 3E                 DC W:$3EFC
1167 9A27 19 5B                 DC W:$5B19
1168 9A29 9F 79                 DC W:$799F
1169 9A2B E7 9A                 DC W:$9AE7
1170 9A2D 5B BF                 DC W:$BF5B                     ; 70
1171 9A2F 7A E7                 DC W:$E77A
1172 9A31 E3 13                 DC W:$13E3
1173 9A33 56 45                 DC W:$4556
1174 9A35 C7 7C                 DC W:$7CC7
1175 9A37 68 BB                 DC W:$BB68                     ; 75
1176 9A39 C2 02                 DC W:$02C2
1177 9A3B DB 54                 DC W:$54DB
1178 9A3D 62 B4                 DC W:$B462
1179 9A3F 01 25                 DC W:$2501
1180 9A41 D9 AB                 DC W:$ABD9                     ; 80
1181 9A43 51 50                 DC W:$5051
1182 9A45 88 1D                 DC W:$1D88
1183 9A47 F3 24                 DC W:$24F3
1184 9A49 AD 83                 DC W:$83AD
1185 9A4B 17 6E                 DC W:$6E17                     ; 85
1186 9A4D F5 4C                 DC W:$4CF5
1187 9A4F BD 14                 DC W:$14BD
1188 9A51 D7 A2                 DC W:$A2D7
1189 9A53 30 4A                 DC W:$4A30
1190 9A55 FF FF                 DC W:$FFFF                     ; 90
1191 9A57
1192 9A57                       ENDP 
1193 9A57
1194 9A57              ****************************************************************
1195 9A57              *
1196 9A57              *              iInitOval
1197 9A57              *
1198 9A57              ****************************************************************
1199 9A57                       EXPORT iInitOval
1200 9A57              iInitOval PROC 
1201 9A57
1202 9A57              * When we enter, x points at the proper oval record, which may not
1203 9A57              * be in the first zero page (it's probably in the 3rd zero page, actually).
1204 9A57              * Note that the stz instruction can't be used.
1205 9A57
1206 9A57              * The oval rectangle is set up by the caller, so we'll just leave it where
1207 9A57              * it already is.  That's just dandy by us.  Pin OvalHeight and OvalWidth
1208 9A57              * to a minimum of 0.
1209 9A57
1210 9A57 B5 08                 lda   OvalHeight,x
1211 9A59 10 05                 bpl   HeightOkay
1212 9A5B A9 00 00              lda   #0
1213 9A5E 95 08                 sta   OvalHeight,x
1214 9A60 B5 0A        HeightOkay lda   OvalWidth,x
1215 9A62 10 05                 bpl   WidthOkay
1216 9A64 A9 00 00              lda   #0
1217 9A67 95 0A                 sta   OvalWidth,x
1218 9A69
1219 9A69              * Pin OvalHeight (OvalWidth) to a maximum of DestHeight (DestWidth)
1220 9A69
1221 9A69 38           WidthOkay sec   
1222 9A6A B5 06                 lda   OvalRight,x
1223 9A6C F5 02                 sbc   OvalLeft,x
1224 9A6E D5 0A                 cmp   OvalWidth,x
1225 9A70 10 02                 bpl   OWidthOkay
1226 9A72 95 0A                 sta   OvalWidth,x
1227 9A74 38           OWidthOkay sec   
1228 9A75 B5 04                 lda   OvalBottom,x
1229 9A77 F5 00                 sbc   OvalTop,x
1230 9A79 D5 08                 cmp   OvalHeight,x
1231 9A7B 10 02                 bpl   OHeightOkay
1232 9A7D 95 08                 sta   OvalHeight,x
1233 9A7F
1234 9A7F              * Set up oval left edge and oval right edge, fixed point numbers.  To
1235 9A7F              * begin with, set things to be zeroed to zero while we have #0 in A
1236 9A7F
1237 9A7F A9 00 00     OHeightOkay lda   #0
1238 9A82 95 0C                 sta   ORightEdge,x
1239 9A84 95 10                 sta   OLeftEdge,x
1240 9A86
1241 9A86 95 18                 sta   Square,x
1242 9A88 95 1A                 sta   Square+2,x
1243 9A8A 95 1C                 sta   Square+4,x
1244 9A8C 95 1E                 sta   Square+6,x
1245 9A8E
1246 9A8E 95 16                 sta   Rsqysq+2,x
1247 9A90
1248 9A90 B5 06                 lda   OvalRight,x
1249 9A92 95 0E                 sta   ORightEdge+2,x
1250 9A94 B5 02                 lda   OvalLeft,x
1251 9A96 95 12                 sta   OLeftEdge+2,x
1252 9A98
1253 9A98 64 2A                 stz   Temp
1254 9A9A B5 0A                 lda   OvalWidth,x
1255 9A9C 85 2C                 sta   Temp+2
1256 9A9E 46 2C                 lsr   Temp+2
1257 9AA0 66 2A                 ror   Temp
1258 9AA2
1259 9AA2 18                    clc   
1260 9AA3 B5 10                 lda   OLeftEdge,x
1261 9AA5 65 2A                 adc   Temp
1262 9AA7 95 10                 sta   OLeftEdge,x
1263 9AA9 B5 12                 lda   OLeftEdge+2,x
1264 9AAB 65 2C                 adc   Temp+2
1265 9AAD 95 12                 sta   OLeftEdge+2,x
1266 9AAF
1267 9AAF 38                    sec   
1268 9AB0 B5 0C                 lda   ORightEdge,x
1269 9AB2 E5 2A                 sbc   Temp
1270 9AB4 95 0C                 sta   ORightEdge,x
1271 9AB6 B5 0E                 lda   ORightEdge+2,x
1272 9AB8 E5 2C                 sbc   Temp+2
1273 9ABA 95 0E                 sta   ORightEdge+2,x
1274 9ABC
1275 9ABC 18                    clc   
1276 9ABD A9 00 80              lda   #$8000
1277 9AC0 75 0C                 adc   ORightEdge,x
1278 9AC2 95 0C                 sta   ORightEdge,x
1279 9AC4 90 02                 bcc   T1
1280 9AC6 F6 0E                 inc   ORightEdge+2,x
1281 9AC8
1282 9AC8 B5 08        T1       lda   OvalHeight,x             ; calc 1-OvalHeight
1283 9ACA 49 FF FF              eor   #$FFFF                   ; negate it
1284 9ACD 1A                    inc   a
1285 9ACE 1A                    inc   a
1286 9ACF 95 30                 sta   OvalY,x
1287 9AD1
1288 9AD1 B5 08                 lda   OvalHeight,x
1289 9AD3 0A                    asl   A                        ; double it
1290 9AD4 3A                    dec   a                        ; -1
1291 9AD5 95 14                 sta   Rsqysq,x
1292 9AD7
1293 9AD7              * OddNum := (AspectRatio ^2), and while we're at it we can set
1294 9AD7              * OddBump := 2 * (AspectRatio ^2) by just storing it and rotating
1295 9AD7              * it at the same time.
1296 9AD7
1297 9AD7 DA                    phx                            ; save x
1298 9AD8 F4 00 00              pea   0                        ; push 64 bit result
1299 9ADB F4 00 00              pea   0
1300 9ADE F4 00 00              pea   0
1301 9AE1 F4 00 00              pea   0
1302 9AE4
1303 9AE4 F4 00 00              pea   0                        ; push 32 bit result
1304 9AE7 F4 00 00              pea   0
1305 9AEA B5 08                 lda   OvalHeight,x
1306 9AEC 48                    pha   
1307 9AED B5 0A                 lda   OvalWidth,x
1308 9AEF 48                    pha   
1309 9AF0 A2 0B 0E 22           _FixRatio 
1310 9AF7 A3 03                 lda   3,s                      ; duplicate high word
1311 9AF9 48                    pha   
1312 9AFA A3 03                 lda   3,s                      ; duplicate low word
1313 9AFC 48                    pha   
1314 9AFD A2 0B 0C 22           _LongMul                       ; calc 64 bit (Height/Width) squared
1315 9B04 A3 09                 lda   9,s                      ; get x back
1316 9B06 AA                    tax   
1317 9B07 68                    pla   
1318 9B08 95 20                 sta   OddNum,x
1319 9B0A 0A                    asl   A
1320 9B0B 95 28                 sta   OddBump,x
1321 9B0D 68                    pla   
1322 9B0E 95 22                 sta   OddNum+2,x
1323 9B10 2A                    rol   A
1324 9B11 95 2A                 sta   OddBump+2,x
1325 9B13 68                    pla   
1326 9B14 95 24                 sta   OddNum+4,x
1327 9B16 2A                    rol   A
1328 9B17 95 2C                 sta   OddBump+4,x
1329 9B19 68                    pla   
1330 9B1A 95 26                 sta   OddNum+6,x
1331 9B1C 2A                    rol   A
1332 9B1D 95 2E                 sta   OddBump+6,x
1333 9B1F FA                    plx                            ; clean the stack
1334 9B20
1335 9B20 6B                    rtl   
1336 9B21
1337 9B21                       ENDP 
1338 9B21
1339 9B21              ****************************************************************
1340 9B21              *
1341 9B21              *              iBumpOval
1342 9B21              *
1343 9B21              ****************************************************************
1344 9B21                       EXPORT iBumpOval
1345 9B21              iBumpOval PROC 
1346 9B21
1347 9B21 A5 40                 lda   CurrentY
1348 9B23 D5 00                 cmp   OvalTop,x
1349 9B25 30 04                 bmi   GoHome
1350 9B27
1351 9B27 D5 04                 cmp   OvalBottom,x
1352 9B29 30 4B                 bmi   While1
1353 9B2B 6B           GoHome   rtl   
1354 9B2C
1355 9B2C              * While square < Rsqysq do make oval bigger
1356 9B2C
1357 9B2C              More1                                   ; 
1358 9B2C
1359 9B2C              * ORightedge := ORightedge + 1/2
1360 9B2C
1361 9B2C B5 0C                 lda   ORightEdge,x
1362 9B2E 18                    clc   
1363 9B2F 69 00 80              adc   #$8000                   ; one half
1364 9B32 95 0C                 sta   ORightEdge,x
1365 9B34 90 02                 bcc   NoBump1
1366 9B36 F6 0E                 inc   ORightEdge+2,x
1367 9B38
1368 9B38              * OLeftEdge := OLeftEdge - 1/2
1369 9B38
1370 9B38 B5 10        NoBump1  lda   OLeftEdge,x
1371 9B3A 38                    sec   
1372 9B3B E9 00 80              sbc   #$8000                   ; one half
1373 9B3E 95 10                 sta   OLeftEdge,x
1374 9B40 B0 02                 bcs   NoDock1
1375 9B42 D6 12                 dec   OLeftEdge+2,x
1376 9B44
1377 9B44              * Square := Square + OddNum
1378 9B44
1379 9B44 18           NoDock1  clc   
1380 9B45 B5 18                 lda   Square,x
1381 9B47 75 20                 adc   OddNum,x
1382 9B49 95 18                 sta   Square,x
1383 9B4B B5 1A                 lda   Square+2,x
1384 9B4D 75 22                 adc   OddNum+2,x
1385 9B4F 95 1A                 sta   Square+2,x
1386 9B51 B5 1C                 lda   Square+4,x
1387 9B53 75 24                 adc   OddNum+4,x
1388 9B55 95 1C                 sta   Square+4,x
1389 9B57 B5 1E                 lda   Square+6,x
1390 9B59 75 26                 adc   OddNum+6,x
1391 9B5B 95 1E                 sta   Square+6,x
1392 9B5D
1393 9B5D              * OddNum := OddNum + OddBump
1394 9B5D
1395 9B5D 18                    clc   
1396 9B5E B5 20                 lda   OddNum,x
1397 9B60 75 28                 adc   OddBump,x
1398 9B62 95 20                 sta   OddNum,x
1399 9B64 B5 22                 lda   OddNum+2,x
1400 9B66 75 2A                 adc   OddBump+2,x
1401 9B68 95 22                 sta   OddNum+2,x
1402 9B6A B5 24                 lda   OddNum+4,x
1403 9B6C 75 2C                 adc   OddBump+4,x
1404 9B6E 95 24                 sta   OddNum+4,x
1405 9B70 B5 26                 lda   OddNum+6,x
1406 9B72 75 2E                 adc   OddBump+6,x
1407 9B74 95 26                 sta   OddNum+6,x
1408 9B76
1409 9B76 B5 1E        While1   lda   Square+6,x
1410 9B78 D5 16                 cmp   Rsqysq+2,x               ; is Square < Rsqysq ?
1411 9B7A
1412 9B7A              * Note: the 65816 cmp instruction doesn't work right.  Since square and
1413 9B7A              * Rsqysq should always be positive, use an unsigned branch instruction.
1414 9B7A
1415 9B7A 90 B0                 bcc   More1                    ; yes, loop
1416 9B7C D0 06                 bne   NotLess                  ; no, continue
1417 9B7E
1418 9B7E              * The high words were equal.  Check the low words.
1419 9B7E
1420 9B7E B5 1C                 lda   Square+4,x
1421 9B80 D5 14                 cmp   Rsqysq,x                 ; is Square < Rsqysq ?
1422 9B82 90 A8                 bcc   More1
1423 9B84
1424 9B84 80 4A        NotLess  bra   While2                   ; now backtrack
1425 9B86
1426 9B86              * While Square > Rsqysq do make oval smaller
1427 9B86
1428 9B86              * ORightedge := ORightedge - 1/2
1429 9B86
1430 9B86 38           More2    sec   
1431 9B87 B5 0C                 lda   ORightEdge,x             ; get ORightEdge
1432 9B89 E9 00 80              sbc   #$8000                   ; one half
1433 9B8C 95 0C                 sta   ORightEdge,x             ; save it
1434 9B8E B0 02                 bcs   NoDock2
1435 9B90 D6 0E                 dec   ORightEdge+2,x
1436 9B92
1437 9B92              * OLeftEdge := OLeftEdge + 1/2
1438 9B92
1439 9B92 18           NoDock2  clc   
1440 9B93 B5 10                 lda   OLeftEdge,x              ; get OLeftEdge
1441 9B95 69 00 80              adc   #$8000                   ; one half
1442 9B98 95 10                 sta   OLeftEdge,x              ; save it
1443 9B9A 90 02                 bcc   NoBump2
1444 9B9C F6 12                 inc   OLeftEdge+2,x
1445 9B9E
1446 9B9E              * OddNum := OddNum - OddBump
1447 9B9E
1448 9B9E 38           NoBump2  sec   
1449 9B9F B5 20                 lda   OddNum,x
1450 9BA1 F5 28                 sbc   OddBump,x
1451 9BA3 95 20                 sta   OddNum,x
1452 9BA5 B5 22                 lda   OddNum+2,x
1453 9BA7 F5 2A                 sbc   OddBump+2,x
1454 9BA9 95 22                 sta   OddNum+2,x
1455 9BAB B5 24                 lda   OddNum+4,x
1456 9BAD F5 2C                 sbc   OddBump+4,x
1457 9BAF 95 24                 sta   OddNum+4,x
1458 9BB1 B5 26                 lda   OddNum+6,x
1459 9BB3 F5 2E                 sbc   OddBump+6,x
1460 9BB5 95 26                 sta   OddNum+6,x
1461 9BB7
1462 9BB7              * Square := Square - OddNum
1463 9BB7
1464 9BB7 38                    sec   
1465 9BB8 B5 18                 lda   Square,x
1466 9BBA F5 20                 sbc   OddNum,x
1467 9BBC 95 18                 sta   Square,x
1468 9BBE B5 1A                 lda   Square+2,x
1469 9BC0 F5 22                 sbc   OddNum+2,x
1470 9BC2 95 1A                 sta   Square+2,x
1471 9BC4 B5 1C                 lda   Square+4,x
1472 9BC6 F5 24                 sbc   OddNum+4,x
1473 9BC8 95 1C                 sta   Square+4,x
1474 9BCA B5 1E                 lda   Square+6,x
1475 9BCC F5 26                 sbc   OddNum+6,x
1476 9BCE 95 1E                 sta   Square+6,x
1477 9BD0
1478 9BD0 B5 16        While2   lda   Rsqysq+2,x
1479 9BD2 D5 1E                 cmp   Square+6,x               ; is Square > Rsqysq ?
1480 9BD4
1481 9BD4              * Note: the 65816 cmp instruction doesn't work right.  Since square and
1482 9BD4              * Rsqysq should always be positive, use an unsigned branch instruction.
1483 9BD4
1484 9BD4 90 B0                 bcc   More2                    ; yes, make oval smaller
1485 9BD6 D0 06                 bne   NotMore                  ; no, continue
1486 9BD8
1487 9BD8              * The high words were equal.  Check the low words
1488 9BD8
1489 9BD8 B5 14                 lda   Rsqysq,x
1490 9BDA D5 1C                 cmp   Square+4,x               ; is Square > Rsqysq ?
1491 9BDC 90 A8                 bcc   More2
1492 9BDE
1493 9BDE B5 30        NotMore  lda   OvalY,x
1494 9BE0 1A                    inc   a                        ; bump by 2
1495 9BE1 85 2A                 sta   Temp                     ; capture this value
1496 9BE3 1A                    inc   a
1497 9BE4 95 30                 sta   OvalY,x                  ; save it like we promised we would
1498 9BE6 64 2C                 stz   Temp+2
1499 9BE8 A5 2A                 lda   Temp
1500 9BEA 10 05                 bpl   NotNegative
1501 9BEC A9 FF FF              lda   #$FFFF
1502 9BEF 85 2C                 sta   Temp+2
1503 9BF1 06 2A        NotNegative asl   Temp
1504 9BF3 26 2C                 rol   Temp+2
1505 9BF5 06 2A                 asl   Temp
1506 9BF7 26 2C                 rol   Temp+2
1507 9BF9
1508 9BF9 38                    sec   
1509 9BFA B5 14                 lda   Rsqysq,x
1510 9BFC E5 2A                 sbc   Temp
1511 9BFE 95 14                 sta   Rsqysq,x
1512 9C00 B5 16                 lda   Rsqysq+2,x
1513 9C02 E5 2C                 sbc   Temp+2
1514 9C04 95 16                 sta   Rsqysq+2,x
1515 9C06
1516 9C06 6B                    rtl   
1517 9C07
1518 9C07                       ENDP 
1519 9C07              ;                copy conics/drawconic
1520 9C07              *	   Table of Contents
1521 9C07              *
1522 9C07              * 1.  DrawConic
1523 9C07              *
1524 9C07              *       FrConic        Frames a conic
1525 9C07              *       PConic         Paints a conic in the current pattern
1526 9C07              *       EConic         Erases a conic
1527 9C07              *       IConic         Inverts a conic
1528 9C07              *       FConic         Fills a conic
1529 9C07              *       OvalPenSize    Sets up the pen size or exits, as appropriate
1530 9C07              *       DrawConic      Draws a conic
1531 9C07
1532 9C07              ****************************************************************
1533 9C07              *
1534 9C07              * PConic, FrConic
1535 9C07              *
1536 9C07              ****************************************************************
1537 9C07                       EXPORT FrConic
1538 9C07              FrConic  PROC 
1539 9C07
1540 9C07              *              using E0Vectors
1541 9C07
1542 9C07 20 0D 9C              jsr   OvalPenSize              ; don't come back unless visible
1543 9C0A
1544 9C0A 4C A4 2E              jmp   CommonSlabSetup
1545 9C0D
1546 9C0D                       ENDP 
1547 9C0D
1548 9C0D
1549 9C0D              ****************************************************************
1550 9C0D              *
1551 9C0D              * OvalPenSize
1552 9C0D              *
1553 9C0D              * Get the PnSize from the port and puts it in PenWidth and
1554 9C0D              * PenHeight.  It also checks to see if either is 0.  If it is then
1555 9C0D              * we do an rtl for the calling routine.
1556 9C0D              *
1557 9C0D              ****************************************************************
1558 9C0D                       EXPORT OvalPenSize
1559 9C0D              OvalPenSize PROC 
1560 9C0D
1561 9C0D              * PenWidth and PenHeight overlap Temp2.  This routine should be called
1562 9C0D              * just before using them or they'll be wiped away...
1563 9C0D
1564 9C0D              *              using CoreDATA
1565 9C0D
1566 9C0D A0 44 00              ldy   #O_PnSize
1567 9C10 B7 24                 lda   [PortRef],y
1568 9C12 F0 0B                 beq   NowWaitAMin
1569 9C14 85 2E                 sta   PenHeight
1570 9C16 C8                    iny   
1571 9C17 C8                    iny   
1572 9C18 B7 24                 lda   [PortRef],y
1573 9C1A F0 03                 beq   NowWaitAMin
1574 9C1C 85 30                 sta   PenWidth
1575 9C1E
1576 9C1E 60                    rts   
1577 9C1F
1578 9C1F 68           NowWaitAMin pla                         ; get rts adr off stack
1579 9C20 18                    clc                            ; remember that this terminates call
1580 9C21 A9 00 00              lda   #0                       ; with no error
1581 9C24 6B                    rtl                            ; do rtl for calling routine
1582 9C25
1583 9C25                       ENDP 
1584 9C25
1585 9C25              ****************************************************************
1586 9C25              *
1587 9C25              * DrawConic
1588 9C25              *
1589 9C25              * The common arc, oval, and round rect drawing routine.  Draws
1590 9C25              * within OvalRect with a curvature specified by OvalWidth
1591 9C25              * and OvalHeight and an angle from StartAngle to StartAngle+ArcAngle.
1592 9C25              *
1593 9C25              * By the time control reaches any of the Conic routines, StartAngle,
1594 9C25              * ArcAngle, HollowFlag, OvalTop..OvalRight, OvalWidth and OvalHeight
1595 9C25              * have all been set properly.  When ready to do a slab, we put our
1596 9C25              * calculated endpoints in X1 and X2 and call the slab routine.
1597 9C25              *
1598 9C25              ****************************************************************
1599 9C25                       EXPORT iDrawConic
1600 9C25              iDrawConic PROC 
1601 9C25
1602 9C25              *              using E0Vectors
1603 9C25
1604 9C25              * Adjust if ArcAngle negative, quit if Arc = 0
1605 9C25
1606 9C25 A5 D2                 lda   ArcAngle
1607 9C27 D0 01                 bne   NotZeroAngle
1608 9C29 6B                    rtl   
1609 9C2A
1610 9C2A 8B           NotZeroAngle phb                        ; save the bank reg here
1611 9C2B
1612 9C2B              * Init2Regions takes RgnA and RgnB and does all the init stuff nec.
1613 9C2B              * for seekrgn.
1614 9C2B
1615 9C2B 22 C0 1E E0           jsl   Init2Regions
1616 9C2F
1617 9C2F              * SetSlabAdr uses penmode and flag called rgns are rect and it decides
1618 9C2F              * which is the appropriate slab routine.
1619 9C2F
1620 9C2F 22 E8 1E E0           jsl   SetSlabAdr               ; sets up the slab adr on zp
1621 9C33
1622 9C33 A5 D2                 lda   ArcAngle
1623 9C35 10 0D                 bpl   PositiveAngle
1624 9C37 18                    clc   
1625 9C38 65 D4                 adc   StartAngle
1626 9C3A 85 D4                 sta   StartAngle
1627 9C3C A5 D2                 lda   ArcAngle
1628 9C3E 49 FF FF              eor   #$FFFF
1629 9C41 1A                    inc   a
1630 9C42 85 D2                 sta   ArcAngle
1631 9C44 64 AE        PositiveAngle stz   ArcFlag             ; initialize
1632 9C46 C9 68 01              cmp   #360                     ; is arc angle < 360 ?
1633 9C49 30 03                 bmi   ItsAnArc
1634 9C4B 82 24 01              brl   NotAnArc
1635 9C4E
1636 9C4E A5 D4        ItsAnArc lda   StartAngle               ; it IS an arc!
1637 9C50 20 FD 9F              jsr   CheckAngle
1638 9C53 85 D4                 sta   StartAngle               ; in case it changed
1639 9C55
1640 9C55 18                    clc   
1641 9C56 65 D2                 adc   ArcAngle                 ; calc StopAngle
1642 9C58 20 FD 9F              jsr   CheckAngle
1643 9C5B 85 F0                 sta   StopAngle
1644 9C5D
1645 9C5D A2 00 02              ldx   #OuterOval
1646 9C60 18                    clc   
1647 9C61 B5 00                 lda   OvalTop,x
1648 9C63 75 04                 adc   OvalBottom,x
1649 9C65
1650 9C65 18                    clc   
1651 9C66 10 01                 bpl   ItsPlus1
1652 9C68 38                    sec   
1653 9C69
1654 9C69 6A           ItsPlus1 ror   a
1655 9C6A 85 B4                 sta   MidVert                  ; MidVert := (top+bottom)/2
1656 9C6C
1657 9C6C 18                    clc   
1658 9C6D B5 02                 lda   OvalLeft,x
1659 9C6F 75 06                 adc   OvalRight,x
1660 9C71 18                    clc   
1661 9C72 10 01                 bpl   ItsPlus2
1662 9C74 38                    sec   
1663 9C75 6A           ItsPlus2 ror   a
1664 9C76
1665 9C76              * MidHoriz overlaps OldRight, considered a temp for this
1666 9C76
1667 9C76 85 F2                 sta   MidHoriz                 ; MidHoriz := (left+right)/2
1668 9C78
1669 9C78 F4 00 00              pea   0                        ; space for result
1670 9C7B F4 00 00              pea   0
1671 9C7E
1672 9C7E 38                    sec   
1673 9C7F B5 06                 lda   OvalRight,x
1674 9C81 F5 02                 sbc   OvalLeft,x
1675 9C83 48                    pha   
1676 9C84 38                    sec   
1677 9C85 B5 04                 lda   OvalBottom,x
1678 9C87 F5 00                 sbc   OvalTop,x
1679 9C89 85 AE                 sta   ArcFlag                  ; a temp, save for later
1680 9C8B 48                    pha   
1681 9C8C
1682 9C8C A2 0B 0E 22           _FixRatio 
1683 9C93
1684 9C93 68                    pla   
1685 9C94 85 E6                 sta   Line1                    ; another temp, for the aspect ratio
1686 9C96 68                    pla   
1687 9C97 85 E8                 sta   Line1+2
1688 9C99
1689 9C99              * Calculate Slope1 from StartAngle
1690 9C99
1691 9C99 A5 D4                 lda   StartAngle
1692 9C9B 85 2A                 sta   Angle                    ; SlopeFromAngle's input
1693 9C9D 22 D8 1F E0           jsl   vSlopeFromAngle
1694 9CA1 F4 00 00              pea   0                        ; _FixMul functon result
1695 9CA4 F4 00 00              pea   0
1696 9CA7 D4 E4                 pei   Slope2+2                 ; push SlopeFromAngle's result
1697 9CA9 D4 E2                 pei   Slope2
1698 9CAB D4 E8                 pei   Line1+2                  ; push the aspect ratio temp
1699 9CAD D4 E6                 pei   Line1
1700 9CAF A2 0B 0F 22           _FixMul 
1701 9CB6 68                    pla   
1702 9CB7 85 DE                 sta   Slope1
1703 9CB9 68                    pla   
1704 9CBA 85 E0                 sta   Slope1+2
1705 9CBC
1706 9CBC              * Calculate Slope2 from StopAngle
1707 9CBC
1708 9CBC A5 F0                 lda   StopAngle
1709 9CBE 85 2A                 sta   Angle                    ; SlopeFromAngle's input
1710 9CC0 22 D8 1F E0           jsl   vSlopeFromAngle
1711 9CC4 F4 00 00              pea   0                        ; _FixMul function result
1712 9CC7 F4 00 00              pea   0
1713 9CCA D4 E4                 pei   Slope2+2                 ; push SlopeFromAngle's result
1714 9CCC D4 E2                 pei   Slope2
1715 9CCE D4 E8                 pei   Line1+2                  ; push the aspect ratio temp
1716 9CD0 D4 E6                 pei   Line1
1717 9CD2 A2 0B 0F 22           _FixMul 
1718 9CD9 68                    pla   
1719 9CDA 85 E2                 sta   Slope2
1720 9CDC 68                    pla   
1721 9CDD 85 E4                 sta   Slope2+2
1722 9CDF
1723 9CDF              * Initialize Line1 := Fixed(MidHoriz) - Slope1 * Fixed(Height div 2).  Height
1724 9CDF              * was saved in ArcFlag, above.
1725 9CDF
1726 9CDF F4 00 00              pea   0                        ; result of FixMul
1727 9CE2 F4 00 00              pea   0
1728 9CE5 A5 AE                 lda   ArcFlag                  ; calc Height div 2
1729 9CE7 4A                    lsr   A
1730 9CE8 49 FF FF              eor   #$FFFF                   ; negate it
1731 9CEB 1A                    inc   a
1732 9CEC 85 AE                 sta   ArcFlag                  ; save it, modified, for later
1733 9CEE 48                    pha   
1734 9CEF F4 00 00              pea   0                        ; a low word of 0
1735 9CF2 D4 E0                 pei   Slope1+2
1736 9CF4 D4 DE                 pei   Slope1
1737 9CF6 A2 0B 0F 22           _FixMul 
1738 9CFD 68                    pla   
1739 9CFE 85 E6                 sta   Line1                    ; low word not affected by MidHoriz
1740 9D00 68                    pla   
1741 9D01 18                    clc   
1742 9D02 65 F2                 adc   MidHoriz                 ; add in MidHoriz
1743 9D04 85 E8                 sta   Line1+2                  ; ta dah!
1744 9D06
1745 9D06              * Initialize Line2 := Fixed(MidHoriz) - Slope2 * Fixed(Height div 2).
1746 9D06              * -(Height div 2) was saved in ArcFlag, above.
1747 9D06
1748 9D06 F4 00 00              pea   0                        ; result of FixMul
1749 9D09 F4 00 00              pea   0
1750 9D0C D4 AE                 pei   ArcFlag                  ; from our friend, above
1751 9D0E F4 00 00              pea   0                        ; a low word of 0
1752 9D11 D4 E4                 pei   Slope2+2
1753 9D13 D4 E2                 pei   Slope2
1754 9D15 A2 0B 0F 22           _FixMul 
1755 9D1C
1756 9D1C 68                    pla   
1757 9D1D 85 EA                 sta   Line2                    ; low word not affected by MidHoriz
1758 9D1F 68                    pla   
1759 9D20 18                    clc   
1760 9D21 65 F2                 adc   MidHoriz                 ; add in MidHoriz
1761 9D23 85 EC                 sta   Line2+2                  ; ta dah!
1762 9D25
1763 9D25              * Set up Flag1 and Flag2 to tell which half each line is active in.
1764 9D25              * The code is, negative = active in top, positive = active in bottom, and
1765 9D25              * 0 = horizontal.
1766 9D25
1767 9D25 A5 D4                 lda   StartAngle               ; is StartAngle < 180 ?
1768 9D27 C9 B4 00              cmp   #180
1769 9D2A 10 06                 bpl   T1                       ; no, continue
1770 9D2C 38                    sec   
1771 9D2D E9 5A 00              sbc   #90                      ; yes, Flag1 := StartAngle-90
1772 9D30 80 06                 bra   T2
1773 9D32 38           T1       sec   
1774 9D33 A9 0E 01              lda   #270
1775 9D36 E5 D4                 sbc   StartAngle               ; Flag1 := 270-StartAngle
1776 9D38 85 DA        T2       sta   Flag1
1777 9D3A
1778 9D3A A5 F0                 lda   StopAngle                ; is StopAngle < 180 ?
1779 9D3C C9 B4 00              cmp   #180
1780 9D3F 10 06                 bpl   T3                       ; no, continue
1781 9D41 38                    sec   
1782 9D42 E9 5A 00              sbc   #90                      ; yes, Flag2 := StopAngle-90
1783 9D45 80 06                 bra   T4
1784 9D47 38           T3       sec   
1785 9D48 A9 0E 01              lda   #270
1786 9D4B E5 F0                 sbc   StopAngle                ; Flag2 := 270-StopAngle
1787 9D4D 85 DC        T4       sta   Flag2
1788 9D4F
1789 9D4F              * Set up SkipFlag to skip over unused arc portions
1790 9D4F
1791 9D4F 64 B2                 stz   SkipFlag                 ; initialize to zero
1792 9D51
1793 9D51 A9 B4 00              lda   #180                     ; is ArcAngle > 180 ?
1794 9D54 C5 D2                 cmp   ArcAngle
1795 9D56 30 15                 bmi   Obtuse                   ; skip if angle > 180
1796 9D58 D0 0B                 bne   Acute                    ; deal with acute angle
1797 9D5A A5 D4                 lda   StartAngle               ; so, ArcAngle is 180
1798 9D5C C9 5A 00              cmp   #90                      ; skip if StartAngle=90
1799 9D5F D0 0C                 bne   Obtuse
1800 9D61 E6 B2                 inc   SkipFlag
1801 9D63 80 08                 bra   Obtuse
1802 9D65
1803 9D65 A5 DA        Acute    lda   Flag1                    ; SkipFlag := (Flag1 | Flag2) > 0
1804 9D67 05 DC                 ora   Flag2
1805 9D69 30 02                 bmi   Obtuse
1806 9D6B E6 B2                 inc   SkipFlag
1807 9D6D
1808 9D6D A9 01 00     Obtuse   lda   #1                       ; restore our temp to True
1809 9D70 85 AE                 sta   ArcFlag
1810 9D72
1811 9D72              NotAnArc                                ; 
1812 9D72
1813 9D72              * Init outer oval state record
1814 9D72
1815 9D72 A2 00 02              ldx   #OuterOval
1816 9D75 22 A4 1F E0           jsl   InitOval
1817 9D79
1818 9D79              * Calculate SkipTop and SkipBot
1819 9D79
1820 9D79 B5 08                 lda   OvalHeight,x             ; get oval height
1821 9D7B 4A                    lsr   A                        ; calc oval height div 2
1822 9D7C 85 2A                 sta   Temp
1823 9D7E 75 00                 adc   OvalTop,x                ; add oval top
1824 9D80 85 D6                 sta   SkipTop                  ; save it
1825 9D82
1826 9D82 38                    sec   
1827 9D83 B5 04                 lda   OvalBottom,x
1828 9D85 E5 2A                 sbc   Temp
1829 9D87 85 D8                 sta   SkipBot
1830 9D89
1831 9D89              * If this is a hollow oval, then calculate DstRect inset by
1832 9D89              * pensize and iInitOval.  If inneroval is empty, switch to a solid oval.
1833 9D89
1834 9D89 64 B0                 stz   InnerFlag
1835 9D8B A2 00 02              ldx   #512
1836 9D8E
1837 9D8E A5 EE                 lda   HollowFlag
1838 9D90 F0 65                 beq   Solid
1839 9D92
1840 9D92 A2 00 02              ldx   #OuterOval
1841 9D95
1842 9D95 20 0D 9C              jsr   OvalPenSize              ; this will return - it did once
1843 9D98
1844 9D98 38                    sec   
1845 9D99 B5 06                 lda   OvalRight,x
1846 9D9B E5 30                 sbc   PenWidth
1847 9D9D 85 F4                 sta   InnerRight
1848 9D9F
1849 9D9F 18                    clc   
1850 9DA0 B5 02                 lda   OvalLeft,x
1851 9DA2 65 30                 adc   PenWidth
1852 9DA4 85 F2                 sta   InnerLeft
1853 9DA6
1854 9DA6 C5 F4                 cmp   InnerRight
1855 9DA8 10 4D                 bpl   Solid
1856 9DAA
1857 9DAA 38                    sec   
1858 9DAB B5 04                 lda   OvalBottom,x
1859 9DAD E5 2E                 sbc   PenHeight
1860 9DAF 85 F0                 sta   OuterRight
1861 9DB1
1862 9DB1 18                    clc   
1863 9DB2 B5 00                 lda   OvalTop,x
1864 9DB4 65 2E                 adc   PenHeight
1865 9DB6 85 EE                 sta   OuterLeft
1866 9DB8
1867 9DB8 C5 F0                 cmp   OuterRight
1868 9DBA 10 3B                 bpl   Solid
1869 9DBC
1870 9DBC              * Initialize the inner oval
1871 9DBC
1872 9DBC E6 B0                 inc   InnerFlag                ; we mean business
1873 9DBE
1874 9DBE A2 32 02              ldx   #InnerOval
1875 9DC1 A5 F4                 lda   InnerRight               ; inner right
1876 9DC3 95 06                 sta   OvalRight,x
1877 9DC5 A5 F2                 lda   InnerLeft                ; inner left
1878 9DC7 95 02                 sta   OvalLeft,x
1879 9DC9
1880 9DC9 A5 F0                 lda   OuterRight               ; inner bottom
1881 9DCB 95 04                 sta   OvalBottom,x
1882 9DCD A5 EE                 lda   OuterLeft                ; inner top
1883 9DCF 95 00                 sta   OvalTop,x
1884 9DD1
1885 9DD1 A2 00 02              ldx   #OuterOval
1886 9DD4
1887 9DD4 A5 30                 lda   PenWidth                 ; InnerWidth := OvalWidth-2*PenWidth
1888 9DD6 0A                    asl   A
1889 9DD7 49 FF FF              eor   #$FFFF
1890 9DDA 1A                    inc   a
1891 9DDB 18                    clc   
1892 9DDC 75 0A                 adc   OvalWidth,x
1893 9DDE 85 F4                 sta   InnerRight               ; temp
1894 9DE0
1895 9DE0 A5 2E                 lda   PenHeight                ; InnerHeight := OvalHeight-2*PenHeight
1896 9DE2 0A                    asl   A
1897 9DE3 49 FF FF              eor   #$FFFF
1898 9DE6 1A                    inc   a
1899 9DE7 18                    clc   
1900 9DE8 75 08                 adc   OvalHeight,x
1901 9DEA
1902 9DEA A2 32 02              ldx   #InnerOval
1903 9DED
1904 9DED 95 08                 sta   OvalHeight,x
1905 9DEF A5 F4                 lda   InnerRight
1906 9DF1 95 0A                 sta   OvalWidth,x
1907 9DF3
1908 9DF3 22 A4 1F E0           jsl   InitOval                 ; with x set to InnerOval offset
1909 9DF7
1910 9DF7              * Grab OuterOval.OvalTop and figure out where in the pixel map its
1911 9DF7              * scan line is.
1912 9DF7
1913 9DF7 A2 00 02     Solid    ldx   #OuterOval
1914 9DFA B5 00                 lda   OvalTop,x
1915 9DFC 85 40                 sta   CurrentY
1916 9DFE 38                    sec   
1917 9DFF E5 14                 sbc   BoundsRect
1918 9E01
1919 9E01
1920 9E01 20 47 34              jsr   SetFirstDestRef
1921 9E04
1922 9E04
1923 9E04
1924 9E04              OvalLoop                                ; 
1925 9E04
1926 9E04              ; Now pull out right slice for current y
1927 9E04 20 C5 34              jsr   NextPatSlice
1928 9E07
1929 9E07              ; takes as input currentY (global), seek of RgnA and RgnB (clip and vis)
1930 9E07 22 CC 1E E0           jsl   Seek2Regions
1931 9E0B
1932 9E0B A2 00 02              ldx   #OuterOval
1933 9E0E B5 10                 lda   OLeftEdge,x              ; save away old values for inner
1934 9E10 85 F6                 sta   OldOuterLeft
1935 9E12 B5 0E                 lda   ORightEdge+2,x
1936 9E14 85 F8                 sta   OldOuterRight
1937 9E16 A5 40                 lda   CurrentY                 ; get current V
1938 9E18 C5 D6                 cmp   SkipTop                  ; is vert < SkipTop
1939 9E1A 30 04                 bmi   YesBump                  ; yes, bump oval record
1940 9E1C C5 D8                 cmp   SkipBot                  ; is vert >= SkipBot
1941 9E1E 30 12                 bmi   NoBump                   ; no, skip bumping
1942 9E20
1943 9E20 A2 00 02     YesBump  ldx   #OuterOval
1944 9E23 22 A0 1F E0           jsl   BumpOval                 ; advance edges
1945 9E27 A5 B0                 lda   InnerFlag                ; are we hollow?
1946 9E29 F0 07                 beq   NoBump
1947 9E2B A2 32 02              ldx   #InnerOval
1948 9E2E 22 A0 1F E0           jsl   BumpOval                 ; advance inner edges
1949 9E32
1950 9E32              NoBump                                  ; 
1951 9E32 A5 AE                 lda   ArcFlag
1952 9E34 D0 03                 bne   CheckFlags
1953 9E36 82 4B 01              brl   DoOvals
1954 9E39
1955 9E39 A5 40        CheckFlags lda   CurrentY
1956 9E3B C5 B4                 cmp   MidVert                  ; is CurrentY = MidVert ?
1957 9E3D D0 31                 bne   NotMid
1958 9E3F
1959 9E3F              * Adjust arc stuff as we cross the middle vertically
1960 9E3F
1961 9E3F A5 DA                 lda   Flag1                    ; invert flags as we cross midpoint
1962 9E41 49 FF FF              eor   #$FFFF
1963 9E44 1A                    inc   a
1964 9E45 85 DA                 sta   Flag1
1965 9E47 A5 DC                 lda   Flag2
1966 9E49 49 FF FF              eor   #$FFFF
1967 9E4C 1A                    inc   a
1968 9E4D 85 DC                 sta   Flag2
1969 9E4F
1970 9E4F              * Recalculate SkipFlag and quit if it becomes true - add stuff in here
1971 9E4F
1972 9E4F 64 B2                 stz   SkipFlag
1973 9E51
1974 9E51 A9 B4 00              lda   #180                     ; is ArcAngle > 180 ?
1975 9E54 C5 D2                 cmp   ArcAngle
1976 9E56 30 15                 bmi   Obtuse1                  ; skip if angle > 180
1977 9E58 D0 0A                 bne   Acute1                   ; deal with acute angle
1978 9E5A A5 D4                 lda   StartAngle               ; so, ArcAngle is 180
1979 9E5C C9 0E 01              cmp   #270                     ; done if StartAngle=270
1980 9E5F D0 0C                 bne   Obtuse1
1981 9E61 82 71 01              brl   Eureka
1982 9E64
1983 9E64 A5 DA        Acute1   lda   Flag1                    ; done if (Flag1 | Flag2) > 0
1984 9E66 05 DC                 ora   Flag2
1985 9E68 30 03                 bmi   Obtuse1
1986 9E6A 82 68 01              brl   Eureka
1987 9E6D
1988 9E6D              * Now swap the roles of Line1 and Line2 as they cross the middle
1989 9E6D
1990 9E6D 20 10 A0     Obtuse1  jsr   SwapLines
1991 9E70
1992 9E70 A5 B2        NotMid   lda   SkipFlag
1993 9E72 F0 03                 beq   DoArc
1994 9E74 82 57 01              brl   NextPat
1995 9E77
1996 9E77              * Solid or hollow arc.  Calculate OuterLeft and OuterRight
1997 9E77
1998 9E77              DoArc                                   ; 
1999 9E77 A5 40                 lda   CurrentY
2000 9E79 C5 00                 cmp   MinRect
2001 9E7B 10 03                 bpl   TopOK1
2002 9E7D 82 4E 01              brl   NextPat
2003 9E80              TopOK1                                  ; 
2004 9E80 A2 00 02              ldx   #OuterOval
2005 9E83 B5 12                 lda   OLeftEdge+2,x            ; get hi word of OuterOval.LeftEdge
2006 9E85 A4 DA                 ldy   Flag1                    ; is Line1 active?
2007 9E87 10 06                 bpl   DA1
2008 9E89 C5 E8                 cmp   Line1+2                  ; yes, check Line1 horiz coord
2009 9E8B 10 02                 bpl   DA1
2010 9E8D A5 E8                 lda   Line1+2
2011 9E8F 85 EE        DA1      sta   OuterLeft
2012 9E91 B5 0E                 lda   ORightEdge+2,x           ; get hi word of OuterOval.RightEdge
2013 9E93 A4 DC                 ldy   Flag2                    ; is Line2 active?
2014 9E95 10 08                 bpl   DA2
2015 9E97 C5 EC                 cmp   Line2+2
2016 9E99 30 04                 bmi   DA2
2017 9E9B F0 02                 beq   DA2
2018 9E9D A5 EC                 lda   Line2+2
2019 9E9F 85 F0        DA2      sta   OuterRight
2020 9EA1 A5 B0                 lda   InnerFlag
2021 9EA3 F0 0D                 beq   SArc
2022 9EA5
2023 9EA5              * may want to double check how currenty is being used - probably bump
2024 9EA5              * it down near NextPat, not way up here.
2025 9EA5
2026 9EA5 A2 32 02              ldx   #InnerOval
2027 9EA8 A5 40                 lda   CurrentY
2028 9EAA D5 00                 cmp   OvalTop,x
2029 9EAC 30 04                 bmi   SArc
2030 9EAE D5 04                 cmp   OvalBottom,x
2031 9EB0 30 3E                 bmi   Harc
2032 9EB2
2033 9EB2 A2 00 02     SArc     ldx   #OuterOval
2034 9EB5 A5 EE                 lda   OuterLeft
2035 9EB7 C5 F0                 cmp   OuterRight
2036 9EB9 10 0C                 bpl   DividedWedge
2037 9EBB 85 A8                 sta   X1
2038 9EBD A5 F0                 lda   OuterRight
2039 9EBF 85 AC                 sta   X2
2040 9EC1 20 39 A0              jsr   DoSlab
2041 9EC4 82 07 01              brl   NextPat
2042 9EC7
2043 9EC7 A5 DA        DividedWedge lda   Flag1
2044 9EC9 25 DC                 and   Flag2                    ; are both lines active?
2045 9ECB 10 20                 bpl   ToNextPat
2046 9ECD A9 B4 00              lda   #180
2047 9ED0 C5 D2                 cmp   ArcAngle                 ; is the angle > 180 ?
2048 9ED2 10 19                 bpl   ToNextPat
2049 9ED4
2050 9ED4 B5 12                 lda   OLeftEdge+2,x
2051 9ED6 85 A8                 sta   X1
2052 9ED8 A5 F0                 lda   OuterRight
2053 9EDA 85 AC                 sta   X2
2054 9EDC 20 39 A0              jsr   DoSlab
2055 9EDF
2056 9EDF A2 00 02              ldx   #OuterOval
2057 9EE2 A5 EE                 lda   OuterLeft
2058 9EE4 85 A8                 sta   X1
2059 9EE6 B5 0E                 lda   ORightEdge+2,x
2060 9EE8 85 AC                 sta   X2
2061 9EEA 20 39 A0     DoASlab  jsr   DoSlab
2062 9EED 82 DE 00     ToNextPat brl   NextPat
2063 9EF0
2064 9EF0              HArc                                    ; 
2065 9EF0 A2 32 02              ldx   #InnerOval
2066 9EF3 B5 12                 lda   OLeftEdge+2,x
2067 9EF5 A4 DC                 ldy   Flag2
2068 9EF7 10 08                 bpl   HA1
2069 9EF9 C5 EC                 cmp   Line2+2
2070 9EFB 30 04                 bmi   HA1
2071 9EFD F0 02                 beq   HA1
2072 9EFF A5 EC                 lda   Line2+2
2073 9F01 85 F2        HA1      sta   InnerLeft
2074 9F03
2075 9F03 B5 0E                 lda   ORightEdge+2,x
2076 9F05 A4 DA                 ldy   Flag1
2077 9F07 10 06                 bpl   HA2
2078 9F09 C5 E8                 cmp   Line1+2
2079 9F0B 10 02                 bpl   HA2
2080 9F0D A5 E8                 lda   Line1+2
2081 9F0F 85 F4        HA2      sta   InnerRight
2082 9F11
2083 9F11              * If OuterLeft < OuterRight then paint two slabs
2084 9F11
2085 9F11 A5 EE                 lda   OuterLeft
2086 9F13 C5 F0                 cmp   OuterRight               ; is OuterLeft < OuterRight ?
2087 9F15 10 17                 bpl   HA3                      ; no, continue
2088 9F17 85 A8                 sta   X1
2089 9F19 A5 F2                 lda   InnerLeft
2090 9F1B 85 AC                 sta   X2
2091 9F1D 20 39 A0              jsr   DoSlab
2092 9F20 A5 F4                 lda   InnerRight
2093 9F22 85 A8                 sta   X1
2094 9F24 A5 F0                 lda   OuterRight
2095 9F26 85 AC                 sta   X2
2096 9F28 20 39 A0              jsr   DoSlab
2097 9F2B 82 A0 00              brl   NextPat
2098 9F2E
2099 9F2E              * else if both lines active and angle > 180 then paint two or three slabs
2100 9F2E
2101 9F2E A5 DA        HA3      lda   Flag1
2102 9F30 25 DC                 and   Flag2
2103 9F32 30 03                 bmi   HABothActive
2104 9F34 82 97 00              brl   NextPat
2105 9F37
2106 9F37 A9 B4 00     HABothActive lda   #180
2107 9F3A C5 D2                 cmp   ArcAngle                 ; is ArcAngle > 180 ?
2108 9F3C 30 03                 bmi   HAAngleOkay              ; yes
2109 9F3E 82 8D 00              brl   NextPat
2110 9F41
2111 9F41 A5 F2        HAAngleOkay lda   InnerLeft
2112 9F43 C5 F0                 cmp   OuterRight               ; is InnerLeft = OuterRight?
2113 9F45 D0 0D                 bne   HA4                      ; no, continue
2114 9F47 A5 EE                 lda   OuterLeft
2115 9F49 85 A8                 sta   X1
2116 9F4B A2 32 02              ldx   #InnerOval               ; redundant
2117 9F4E B5 12                 lda   OLeftEdge+2,x            ; yes, draw a third slab
2118 9F50 85 AC                 sta   X2
2119 9F52 80 0E                 bra   HA5
2120 9F54
2121 9F54 A5 EE        HA4      lda   OuterLeft
2122 9F56 C5 F4                 cmp   InnerRight
2123 9F58 D0 0B                 bne   Not3
2124 9F5A B5 0E                 lda   ORightEdge+2,x           ; yes, draw a third slab
2125 9F5C 85 A8                 sta   X1
2126 9F5E A5 F0                 lda   OuterRight
2127 9F60 85 AC                 sta   X2
2128 9F62 20 39 A0     HA5      jsr   DoSlab
2129 9F65
2130 9F65              Not3                                    ; 
2131 9F65 A2 00 02              ldx   #OuterOval
2132 9F68 B5 12                 lda   OLeftEdge+2,x
2133 9F6A 85 A8                 sta   X1
2134 9F6C A5 F2                 lda   InnerLeft
2135 9F6E 85 AC                 sta   X2
2136 9F70 20 39 A0              jsr   DoSlab
2137 9F73
2138 9F73 A2 00 02              ldx   #OuterOval
2139 9F76 A5 F4                 lda   InnerRight
2140 9F78 85 A8                 sta   X1
2141 9F7A B5 0E                 lda   ORightEdge+2,x
2142 9F7C 85 AC                 sta   X2
2143 9F7E 20 39 A0              jsr   DoSlab
2144 9F81 82 4A 00              brl   NextPat
2145 9F84
2146 9F84              * Branch based on solid or hollow oval
2147 9F84
2148 9F84              DoOvals                                 ; 
2149 9F84 A5 40                 lda   CurrentY
2150 9F86 C5 00                 cmp   MinRect
2151 9F88 10 03                 bpl   TopOK2
2152 9F8A 82 41 00              brl   NextPat
2153 9F8D              TopOK2                                  ; 
2154 9F8D A5 B0                 lda   InnerFlag
2155 9F8F F0 2F                 beq   SOval
2156 9F91
2157 9F91 A2 32 02              ldx   #InnerOval
2158 9F94 A5 40                 lda   CurrentY
2159 9F96 D5 00                 cmp   OvalTop,x
2160 9F98 30 26                 bmi   SOval
2161 9F9A D5 04                 cmp   OvalBottom,x
2162 9F9C 10 22                 bpl   SOval
2163 9F9E
2164 9F9E A2 00 02     HOval    ldx   #OuterOval
2165 9FA1 B5 0E                 lda   ORightEdge+2,x
2166 9FA3 48                    pha   
2167 9FA4 B5 12                 lda   OLeftEdge+2,x
2168 9FA6 85 A8                 sta   X1
2169 9FA8
2170 9FA8 A2 32 02              ldx   #InnerOval
2171 9FAB B5 0E                 lda   ORightEdge+2,x
2172 9FAD 48                    pha   
2173 9FAE B5 12                 lda   OLeftEdge+2,x
2174 9FB0 85 AC                 sta   X2
2175 9FB2 20 39 A0              jsr   DoSlab
2176 9FB5
2177 9FB5 68                    pla   
2178 9FB6 85 A8                 sta   X1
2179 9FB8 68                    pla   
2180 9FB9 85 AC                 sta   X2
2181 9FBB 20 39 A0              jsr   DoSlab
2182 9FBE
2183 9FBE 80 0E                 bra   NextPat
2184 9FC0
2185 9FC0              * Solid oval - draw one slab between left and right edges of outer oval
2186 9FC0
2187 9FC0 A2 00 02     SOval    ldx   #OuterOval
2188 9FC3 B5 12                 lda   OLeftEdge+2,x
2189 9FC5 85 A8                 sta   X1
2190 9FC7 B5 0E                 lda   ORightEdge+2,x
2191 9FC9 85 AC                 sta   X2
2192 9FCB 20 39 A0              jsr   DoSlab
2193 9FCE
2194 9FCE A5 40        NextPat  lda   CurrentY
2195 9FD0 1A                    inc   a
2196 9FD1 C5 04                 cmp   MinRect+4
2197 9FD3 30 02                 bmi   NotYetDone
2198 9FD5 AB           Eureka   plb                            ; restore bank
2199 9FD6 6B                    rtl   
2200 9FD7
2201 9FD7 85 40        NotYetDone sta   CurrentY
2202 9FD9 A5 AE                 lda   ArcFlag                  ; do we need to bump lines?
2203 9FDB F0 1A                 beq   NotLining
2204 9FDD 18                    clc   
2205 9FDE A5 DE                 lda   Slope1
2206 9FE0 65 E6                 adc   Line1
2207 9FE2 85 E6                 sta   Line1
2208 9FE4 A5 E0                 lda   Slope1+2
2209 9FE6 65 E8                 adc   Line1+2
2210 9FE8 85 E8                 sta   Line1+2
2211 9FEA 18                    clc   
2212 9FEB A5 E2                 lda   Slope2
2213 9FED 65 EA                 adc   Line2
2214 9FEF 85 EA                 sta   Line2
2215 9FF1 A5 E4                 lda   Slope2+2
2216 9FF3 65 EC                 adc   Line2+2
2217 9FF5 85 EC                 sta   Line2+2
2218 9FF7
2219 9FF7              NotLining                               ; 
2220 9FF7 20 F4 34              jsr   SetNextDestRef
2221 9FFA 82 07 FE              brl   OvalLoop                 ; loop for all verticals
2222 9FFD
2223 9FFD              * In this little procedure we do a crude modulo 360 - this will usually
2224 9FFD              * win big because the parameter passed will generally be in range, but
2225 9FFD              * even if it isn't, this method should still win over the tool call.
2226 9FFD              * Note the status flags coming in must be set on A.
2227 9FFD
2228 9FFD 10 0B        CheckAngle bpl   CheckTooHigh
2229 9FFF 18           BumpAngle clc   
2230 A000 69 68 01              adc   #360
2231 A003 30 FA                 bmi   BumpAngle
2232 A005 60                    rts   
2233 A006
2234 A006 38           DockAngle sec   
2235 A007 E9 68 01              sbc   #360
2236 A00A C9 68 01     CheckTooHigh cmp   #360
2237 A00D 10 F7                 bpl   DockAngle
2238 A00F 60                    rts   
2239 A010
2240 A010              * SwapLines exchanges the meaning of Line1 and Line2 as we cross the middle.
2241 A010              * It's put down here to keep the branches in range up above, since all it is
2242 A010              * is busy work.
2243 A010
2244 A010 A5 DA        SwapLines lda   Flag1
2245 A012 A6 DC                 ldx   Flag2
2246 A014 86 DA                 stx   Flag1
2247 A016 85 DC                 sta   Flag2
2248 A018 A5 E6                 lda   Line1
2249 A01A A6 EA                 ldx   Line2
2250 A01C 86 E6                 stx   Line1
2251 A01E 85 EA                 sta   Line2
2252 A020 A5 E8                 lda   Line1+2
2253 A022 A6 EC                 ldx   Line2+2
2254 A024 86 E8                 stx   Line1+2
2255 A026 85 EC                 sta   Line2+2
2256 A028 A5 DE                 lda   Slope1
2257 A02A A6 E2                 ldx   Slope2
2258 A02C 86 DE                 stx   Slope1
2259 A02E 85 E2                 sta   Slope2
2260 A030 A5 E0                 lda   Slope1+2
2261 A032 A6 E4                 ldx   Slope2+2
2262 A034 86 E0                 stx   Slope1+2
2263 A036 85 E4                 sta   Slope2+2
2264 A038 60                    rts   
2265 A039
2266 A039              * XSetup sets left edge and right edge (and maybe a few masks).
2267 A039              * Set based upon X1 and X2.
2268 A039
2269 A039 A5 AC        DoSlab   lda   x2
2270 A03B C5 02                 cmp   MinRect+2
2271 A03D 30 24                 bmi   DoneSlab
2272 A03F C5 06                 cmp   MinRect+6
2273 A041 30 04                 bmi   X2okay
2274 A043 A5 06                 lda   MinRect+6
2275 A045 85 AC                 sta   X2
2276 A047 A5 A8        X2okay   lda   x1
2277 A049 C5 06                 cmp   MinRect+6
2278 A04B 10 16                 bpl   DoneSlab
2279 A04D C5 02                 cmp   MinRect+2
2280 A04F 10 04                 bpl   X1okay
2281 A051 A5 02                 lda   MinRect+2
2282 A053 85 A8                 sta   X1
2283 A055 A5 A8        X1okay   lda   X1
2284 A057 C5 AC                 cmp   X2
2285 A059 10 08                 bpl   DoneSlab
2286 A05B 22 70 1E E0           jsl   XSetup                   ; call in slab routine
2287 A05F 22 00 1E E0           jsl   ToSlab                   ; draw slab
2288 A063 60           DoneSlab rts   
2289 A064
2290 A064                       ENDP 
2291 A064              ;                copy conics/putoval
2292 A064              *	   Table of Contents
2293 A064              *
2294 A064              * PutOval
2295 A064              *
2296 A064              *       iPutOval       Add oval or round rect points to an open region
2297 A064              ****************************************************************
2298 A064              *
2299 A064              *              iPutOval
2300 A064              *
2301 A064              ****************************************************************
2302 A064                       EXPORT iPutOval
2303 A064              iPutOval PROC 
2304 A064
2305 A064              *              using E0Vectors
2306 A064              *              using ErrorDATA
2307 A064
2308 A064              * Init an oval record
2309 A064
2310 A064              * Parameters are passed on zero page.  OvalWidth and OvalHeight determine
2311 A064              * the shape of the oval.  They are trimmed to DstRect if they are bigger than
2312 A064              * it is.  If DstRect is bigger (in either dimension) the extra space is
2313 A064              * automatically added along the appropriate axis, generating a round rect.
2314 A064
2315 A064 A2 00 02              ldx   #OuterOval
2316 A067 22 A4 1F E0           jsl   InitOval                 ; go to the vector location
2317 A06B
2318 A06B B5 12                 lda   OLeftEdge+2,x
2319 A06D 85 F6                 sta   OldOuterLeft
2320 A06F
2321 A06F B5 0E                 lda   ORightEdge+2,x
2322 A071 85 F8                 sta   OldOuterRight
2323 A073
2324 A073 B5 08                 lda   OvalHeight,x             ; get oval height
2325 A075 4A                    lsr   A                        ; calc oval height div 2
2326 A076 18                    clc   
2327 A077 75 00                 adc   OvalTop,x                ; add oval top
2328 A079 85 D6                 sta   SkipTop                  ; save it
2329 A07B
2330 A07B 18                    clc   
2331 A07C 75 04                 adc   OvalBottom,x             ; add bottom
2332 A07E 38                    sec   
2333 A07F F5 00                 sbc   OvalTop,x                ; subtract top
2334 A081 38                    sec   
2335 A082 F5 08                 sbc   OvalHeight,x             ; subtract OvalHeight
2336 A084 85 D8                 sta   SkipBot                  ; save it
2337 A086
2338 A086              * Dereference handle
2339 A086
2340 A086 A2 BC 00              ldx   #BufHandle
2341 A089 20 0D 5B              jsr   DerefHandle              ; dereference the current handle
2342 A08C 85 C0                 sta   BufPtr                   ; save pointer returned in A & X
2343 A08E 86 C2                 stx   BufPtr+2
2344 A090 A0 02 00              ldy   #2                       ; current index offset
2345 A093 B7 C0                 lda   [BufPtr],y               ; get index
2346 A095 85 C6                 sta   Index                    ; save the pointer to the next point
2347 A097
2348 A097              * More initialization
2349 A097
2350 A097 A2 00 02              ldx   #OuterOval
2351 A09A B5 00                 lda   OvalTop,x
2352 A09C 85 40                 sta   CurrentY
2353 A09E
2354 A09E              * Put the top edge
2355 A09E
2356 A09E A5 F6                 lda   OldOuterLeft
2357 A0A0 20 FF A0              jsr   PutPt                    ; add it to the buffer
2358 A0A3 A5 F8                 lda   OldOuterRight
2359 A0A5 20 FF A0              jsr   PutPt                    ; add this, too
2360 A0A8
2361 A0A8              * For each vertical, bump OLeftEdge and ORightEdge.  If they differ from
2362 A0A8              * OOldLeft and OOldRight, put inversion points for the differences.
2363 A0A8
2364 A0A8 A5 40        NxtVert  lda   CurrentY                 ; get current V
2365 A0AA C5 D6                 cmp   SkipTop                  ; is vert < SkipTop
2366 A0AC 30 04                 bmi   YesBump                  ; yes, bump oval record
2367 A0AE C5 D8                 cmp   SkipBot                  ; is vert >= SkipBot
2368 A0B0 30 2B                 bmi   RightOK                  ; no, skip bumping
2369 A0B2
2370 A0B2 A2 00 02     YesBump  ldx   #OuterOval
2371 A0B5 22 A0 1F E0           jsl   BumpOval                 ; advance edges, using vector
2372 A0B9 B5 12                 lda   OLeftEdge+2,x            ; get OLeftEdge
2373 A0BB C5 F6                 cmp   OldOuterLeft             ; same as OOldLeft?
2374 A0BD F0 0C                 beq   LeftOk                   ; yes, continue
2375 A0BF 20 FF A0              jsr   PutPt                    ; add it to the buffer
2376 A0C2 A5 F6                 lda   OldOuterLeft             ; get old H
2377 A0C4 20 FF A0              jsr   PutPt                    ; add it to the buffer
2378 A0C7 B5 12                 lda   OLeftEdge+2,x            ; get new left
2379 A0C9 85 F6                 sta   OldOuterLeft             ; update old left
2380 A0CB
2381 A0CB              * Check right edge and put two inversion points if it has changed.
2382 A0CB
2383 A0CB B5 0E        LeftOk   lda   ORightEdge+2,x           ; get right edge
2384 A0CD C5 F8                 cmp   OldOuterRight            ; same as OOldRight?
2385 A0CF F0 0C                 beq   RightOk                  ; yes, continue
2386 A0D1 20 FF A0              jsr   PutPt                    ; add it to the buffer
2387 A0D4 A5 F8                 lda   OldOuterRight            ; get old H
2388 A0D6 20 FF A0              jsr   PutPt                    ; put old right edge
2389 A0D9 B5 0E                 lda   ORightEdge+2,x           ; get new value
2390 A0DB 85 F8                 sta   OldOuterRight            ; update old right
2391 A0DD
2392 A0DD A5 40        RightOk  lda   CurrentY                 ; bump scan line
2393 A0DF 1A                    inc   a
2394 A0E0 85 40                 sta   CurrentY
2395 A0E2 D5 04                 cmp   OvalBottom,x             ; are we done yet?
2396 A0E4 30 C2                 bmi   NxtVert                  ; loop for all verticals
2397 A0E6
2398 A0E6              * Put the bottom edge
2399 A0E6
2400 A0E6 A5 F6                 lda   OldOuterLeft
2401 A0E8 20 FF A0              jsr   PutPt
2402 A0EB A5 F8                 lda   OldOuterRight
2403 A0ED 20 FF A0              jsr   PutPt
2404 A0F0
2405 A0F0 A0 02 00              ldy   #2
2406 A0F3 A5 C6                 lda   Index
2407 A0F5 97 C0                 sta   [BufPtr],y               ; update count
2408 A0F7
2409 A0F7 A2 BC 00              ldx   #BufHandle               ; unlock the buffer handle
2410 A0FA 20 28 5B              jsr   UnlockHandle
2411 A0FD 18                    clc   
2412 A0FE 6B                    rtl                            ; go home
2413 A0FF
2414 A0FF              * Local routine which adds points to the buffer.  The y value is in CurrentY
2415 A0FF              * and the x value is in x.  A handle error from here will go back to the main
2416 A0FF              * caller.
2417 A0FF
2418 A0FF AA           PutPt    tax                            ; save a in x
2419 A100 18                    clc   
2420 A101 A5 C6                 lda   Index                    ; get current index
2421 A103 A8                    tay                            ; save it just in case
2422 A104 69 04 00              adc   #4                       ; enough room?
2423 A107 85 C6                 sta   Index                    ; the next value
2424 A109 C7 C0                 cmp   [BufPtr]                 ; do we have enough room?
2425 A10B 90 18                 bcc   SizeOk                   ; if we borrowed, that's good
2426 A10D F0 16                 beq   SizeOk                   ; if they're equal, that's good, too
2427 A10F
2428 A10F DA                    phx                            ; save the value to store
2429 A110 5A                    phy                            ; save the index we need
2430 A111 18                    clc                            ; prepare for add
2431 A112 69 00 04              adc   #1024                    ; room for 256 more points
2432 A115 B0 1D                 bcs   BufferOverflow           ; if we wrapped, we're done
2433 A117 A2 BC 00              ldx   #BufHandle               ; point X at BufHandle
2434 A11A 20 3B 5B              jsr   ReSizeHandle             ; resize, relock, rederef
2435 A11D B0 18                 bcs   ErrorOut                 ; if we failed, propogate the error
2436 A11F 85 C0                 sta   BufPtr                   ; save pointer
2437 A121 86 C2                 stx   BufPtr+2
2438 A123 7A                    ply                            ; restore index
2439 A124 FA                    plx                            ; get the value to store back
2440 A125
2441 A125 A5 40        SizeOk   lda   CurrentY                 ; get the Y value
2442 A127 97 C0                 sta   [BufPtr],y               ; save the y value
2443 A129 C8 C8                 IncYWd                         ; next integer
2444 A12B 8A                    txa                            ; get x value
2445 A12C 97 C0                 sta   [BufPtr],y               ; save the x value
2446 A12E C8 C8                 IncYWd                         ; bump to next point
2447 A130 A2 00 02              ldx   #OuterOval
2448 A133 60                    rts   
2449 A134
2450 A134 A9 33 04     BufferOverflow lda   #RgnFull           ; error to say we had troubles
2451 A137 7A           ErrorOut ply                            ; we pushed y
2452 A138 FA                    plx                            ; we pushed x
2453 A139 FA                    plx                            ; dump the local return
2454 A13A 48                    pha                            ; push error code
2455 A13B A2 BC 00              ldx   #BufHandle               ; unlock the buffer handle
2456 A13E 20 28 5B              jsr   UnlockHandle
2457 A141 38                    sec                            ; set the error flag
2458 A142 68                    pla                            ; pull the error code
2459 A143 6B                    rtl                            ; go home
2460 A144
2461 A144                       ENDP 
2462 A144
2463 A144                       END   
